/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.UnitType;
import java.nio.ByteBuffer;

public final class BooleanType
extends UnitType<Boolean> {
    private static final byte[] BOOLEAN_FALSE = new byte[32];
    private static final byte[] BOOLEAN_TRUE = new byte[32];

    BooleanType() {
        super("bool", Boolean.class, 1, true);
    }

    @Override
    Class<?> arrayClass() {
        return boolean[].class;
    }

    @Override
    public int typeCode() {
        return 0;
    }

    @Override
    int byteLengthPacked(Boolean value) {
        return 1;
    }

    @Override
    void validateInternal(Boolean value) {
    }

    @Override
    void encodeTail(Boolean value, ByteBuffer dest) {
        BooleanType.encodeBoolean(value, dest);
    }

    @Override
    void encodePackedUnchecked(Boolean value, ByteBuffer dest) {
        BooleanType.encodeBooleanPacked(value, dest);
    }

    @Override
    Boolean decode(ByteBuffer bb, byte[] unitBuffer) {
        return BooleanType.decodeBoolean(this.decodeValid(bb, unitBuffer).byteValue());
    }

    static void encodeBooleanPacked(boolean value, ByteBuffer dest) {
        dest.put(value ? (byte)1 : 0);
    }

    static void encodeBoolean(boolean val, ByteBuffer dest) {
        dest.put(val ? BOOLEAN_TRUE : BOOLEAN_FALSE);
    }

    static Boolean decodeBoolean(byte b) {
        switch (b) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException("illegal boolean value: " + b);
    }

    static {
        BooleanType.BOOLEAN_TRUE[BooleanType.BOOLEAN_TRUE.length - 1] = 1;
    }
}

