/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.util.JsonUtils;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import com.google.gson.JsonObject;
import com.joemelsha.crypto.hash.Keccak;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Function
implements ABIObject {
    private static final Pattern ALL_ASCII_NO_OPEN_PAREN = Pattern.compile("^[[^(]&&\\p{ASCII}]*$");
    private static final Pattern OPEN_PAREN_OR_NON_ASCII = Pattern.compile("[([^\\p{ASCII}]]");
    public static final int SELECTOR_LEN = 4;
    private static final int MAX_NAME_CHARS = 2048;
    private final TypeEnum type;
    private final String name;
    private final TupleType inputTypes;
    private final TupleType outputTypes;
    private final String stateMutability;
    private final String hashAlgorithm;
    private final byte[] selector = new byte[4];

    public Function(String signature) {
        this(signature, signature.indexOf(40), TupleType.EMPTY);
    }

    public Function(String signature, String outputs) {
        this(signature, signature.indexOf(40), outputs != null ? TupleType.parse(outputs) : TupleType.EMPTY);
    }

    private Function(String signature, int nameLength, TupleType outputs) {
        this(TypeEnum.FUNCTION, signature.substring(0, nameLength), TupleType.parse(signature.substring(nameLength)), outputs, null, Function.newDefaultDigest());
    }

    public Function(TypeEnum type, String name, TupleType inputs, TupleType outputs, String stateMutability, MessageDigest messageDigest) {
        this.type = Objects.requireNonNull(type);
        this.name = name != null ? Function.validateName(name) : null;
        this.inputTypes = Objects.requireNonNull(inputs);
        this.outputTypes = Objects.requireNonNull(outputs);
        this.stateMutability = stateMutability;
        this.hashAlgorithm = Objects.requireNonNull(messageDigest.getAlgorithm());
        this.validateFunction();
        this.generateSelector(messageDigest);
    }

    @Override
    public TypeEnum getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleType getInputs() {
        return this.inputTypes;
    }

    public TupleType getOutputs() {
        return this.outputTypes;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] selector() {
        return Arrays.copyOf(this.selector, this.selector.length);
    }

    public String selectorHex() {
        return Strings.encode(this.selector);
    }

    @Override
    public String getCanonicalSignature() {
        return this.name != null ? this.name + this.inputTypes.canonicalType : this.inputTypes.canonicalType;
    }

    private void validateFunction() {
        switch (this.type.ordinal()) {
            case 0: {
                if (this.name == null) {
                    throw this.validationErr("define name");
                }
                return;
            }
            case 1: {
                if (this.name != null && !"receive".equals(this.name)) {
                    throw new IllegalArgumentException("unexpected name on receive function: \"" + this.name + '\"');
                }
                if (!"payable".equals(this.stateMutability)) {
                    throw this.validationErr("define stateMutability as \"payable\"");
                }
            }
            case 2: {
                if (!this.inputTypes.isEmpty()) {
                    throw this.validationErr("define no inputs");
                }
            }
            case 3: {
                if (!this.outputTypes.isEmpty()) {
                    throw this.validationErr("define no outputs");
                }
                if (this.name != null && this.type != TypeEnum.RECEIVE) {
                    throw this.validationErr("not define name");
                }
                return;
            }
        }
        throw TypeEnum.unexpectedType(this.type.name);
    }

    private IllegalArgumentException validationErr(String typeRuleStr) {
        return new IllegalArgumentException("type is \"" + (Object)((Object)this.type) + "\"; functions of this type must " + typeRuleStr);
    }

    private void generateSelector(MessageDigest messageDigest) {
        messageDigest.reset();
        messageDigest.update(Strings.decode(this.getCanonicalSignature(), 3));
        try {
            messageDigest.digest(this.selector, 0, 4);
        }
        catch (DigestException de) {
            throw new AssertionError((Object)de);
        }
    }

    private int validatedCallLength(Tuple args) {
        return 4 + this.inputTypes.validate(args);
    }

    public int measureCallLength(Tuple args) {
        return this.validatedCallLength(args);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.encodeCall(new Tuple(args));
    }

    public ByteBuffer encodeCall(Tuple args) {
        ByteBuffer dest = ByteBuffer.allocate(this.validatedCallLength(args));
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
        dest.flip();
        return dest;
    }

    public void encodeCall(Tuple args, ByteBuffer dest) {
        this.inputTypes.validate(args);
        dest.put(this.selector);
        this.inputTypes.encodeTail(args, dest);
    }

    public Tuple decodeCall(byte[] call) {
        this.checkSelector(Arrays.copyOf(call, 4));
        return (Tuple)this.inputTypes.decode(call, 4, call.length - 4);
    }

    public Tuple decodeCall(ByteBuffer buffer) {
        this.checkSelector(buffer);
        return (Tuple)this.inputTypes.decode(buffer);
    }

    public <T> T decodeCall(byte[] call, int ... indices) {
        return this.decodeCall(ByteBuffer.wrap(call), indices);
    }

    public <T> T decodeCall(ByteBuffer buffer, int ... indices) {
        this.checkSelector(buffer);
        return this.inputTypes.decode(buffer, indices);
    }

    private void checkSelector(ByteBuffer bb) {
        byte[] four = new byte[4];
        bb.get(four, 0, four.length);
        this.checkSelector(four);
    }

    private void checkSelector(byte[] found) {
        if (!MessageDigest.isEqual(found, this.selector)) {
            throw new IllegalArgumentException("given selector does not match: expected: " + this.selectorHex() + ", found: " + Strings.encode(found));
        }
    }

    public Tuple decodeReturn(byte[] returnVals) {
        return (Tuple)this.outputTypes.decode(returnVals);
    }

    public Tuple decodeReturn(ByteBuffer buf) {
        return (Tuple)this.outputTypes.decode(buf);
    }

    public <T> T decodeReturn(byte[] returnVals, int ... indices) {
        return this.decodeReturn(ByteBuffer.wrap(returnVals), indices);
    }

    public <T> T decodeReturn(ByteBuffer buf, int ... indices) {
        return this.outputTypes.decode(buf, indices);
    }

    public <J> J decodeSingletonReturn(byte[] singleton) {
        if (this.outputTypes.size() == 1) {
            return ((ABIType)this.outputTypes.get(0)).decode(singleton);
        }
        throw new IllegalArgumentException("return type not a singleton: " + this.outputTypes.canonicalType);
    }

    public <J> J decodeSingletonReturn(ByteBuffer buf) {
        if (this.outputTypes.size() == 1) {
            return ((ABIType)this.outputTypes.get(0)).decode(buf);
        }
        throw new IllegalArgumentException("return type not a singleton: " + this.outputTypes.canonicalType);
    }

    public int hashCode() {
        return 31 * Objects.hash(new Object[]{this.type, this.name, this.inputTypes, this.outputTypes, this.stateMutability, this.hashAlgorithm}) + Arrays.hashCode(this.selector);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function other = (Function)o;
        return other.type == this.type && Objects.equals(other.name, this.name) && other.inputTypes.equals(this.inputTypes) && other.outputTypes.equals(this.outputTypes) && Objects.equals(other.stateMutability, this.stateMutability) && other.hashAlgorithm.equals(this.hashAlgorithm) && MessageDigest.isEqual(other.selector, this.selector);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    private static String validateName(String input) {
        if (input.length() > 2048) {
            throw new IllegalArgumentException("function name is too long: " + input.length() + " > " + 2048);
        }
        if (ALL_ASCII_NO_OPEN_PAREN.matcher(input).matches()) {
            return input;
        }
        Matcher badChar = OPEN_PAREN_OR_NON_ASCII.matcher(input);
        if (badChar.find()) {
            int idx = badChar.start();
            char c = input.charAt(idx);
            throw new IllegalArgumentException("illegal char 0x" + Integer.toHexString(c) + " '" + c + "' @ index " + idx);
        }
        throw new AssertionError((Object)"regex mismatch");
    }

    public static Function parse(String signature) {
        return new Function(signature);
    }

    public static Function parse(String signature, String outputs) {
        return new Function(signature, outputs);
    }

    public static Function fromJson(String objectJson) {
        return Function.fromJsonObject(JsonUtils.parseObject(objectJson));
    }

    public static Function fromJsonObject(JsonObject function) {
        return Function.fromJsonObject(function, Function.newDefaultDigest());
    }

    public static Function fromJsonObject(JsonObject function, MessageDigest digest) {
        return ABIJSON.parseFunction(function, digest);
    }

    public static MessageDigest newDefaultDigest() {
        return new Keccak(256);
    }

    public static String formatCall(byte[] call) {
        return Function.formatCall(call, 0, call.length);
    }

    public static String formatCall(byte[] buffer, int offset, int length) {
        return Function.formatCall(buffer, offset, length, row -> ABIType.pad(0, Integer.toString(row)));
    }

    public static String formatCall(byte[] buffer, int offset, int length, IntFunction<String> labeler) {
        Integers.checkIsMultiple(length - 4, 32);
        return ABIType.finishFormat(buffer, offset + 4, offset + length, labeler, new StringBuilder(ABIType.pad(0, "ID")).append(Strings.encode(buffer, offset, 4, 0)));
    }
}

