/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TypeFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;

public final class TupleType
extends ABIType<Tuple>
implements Iterable<ABIType<?>> {
    static final String EMPTY_TUPLE_STRING = "()";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final TupleType EMPTY = new TupleType("()", false, EMPTY_ARRAY, null);
    final ABIType<?>[] elementTypes;
    final String[] elementNames;
    private final int headLength;
    private final int firstOffset;

    TupleType(String canonicalType, boolean dynamic, ABIType<?>[] elementTypes, String[] elementNames) {
        super(canonicalType, Tuple.class, dynamic);
        this.elementTypes = elementTypes;
        this.elementNames = elementNames;
        if (dynamic) {
            this.headLength = 32;
            int sum = 0;
            for (ABIType<?> elementType : elementTypes) {
                sum += elementType.headLength();
            }
            this.firstOffset = sum;
        } else {
            this.headLength = TupleType.staticTupleHeadLength(this);
            this.firstOffset = -1;
        }
    }

    public int size() {
        return this.elementTypes.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String getElementName(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("index out of bounds: " + index);
        }
        return this.elementNames == null ? null : this.elementNames[index];
    }

    public <T extends ABIType<?>> T get(int index) {
        return (T)this.elementTypes[index];
    }

    public ABIType<Object> getNonCapturing(int index) {
        return this.get(index);
    }

    @Override
    Class<?> arrayClass() {
        return Tuple[].class;
    }

    @Override
    public int typeCode() {
        return 7;
    }

    @Override
    int headLength() {
        return this.headLength;
    }

    @Override
    int dynamicByteLength(Tuple value) {
        return this.countBytes(i -> TupleType.measureObject(this.getNonCapturing(i), value.elements[i]));
    }

    @Override
    int byteLength(Tuple value) {
        if (!this.dynamic) {
            return this.headLength;
        }
        return this.countBytes(i -> TupleType.measureObject(this.getNonCapturing(i), value.elements[i]));
    }

    private static int measureObject(ABIType<Object> type, Object value) {
        return TupleType.totalLen(type.byteLength(value), type.dynamic);
    }

    @Override
    public int byteLengthPacked(Tuple value) {
        Object[] elements = value != null ? value.elements : new Object[this.size()];
        return this.countBytes(i -> this.getNonCapturing(i).byteLengthPacked(elements[i]));
    }

    private int countBytes(IntUnaryOperator counter) {
        return TupleType.countBytes(false, this.elementTypes.length, counter);
    }

    static int countBytes(boolean array, int len, IntUnaryOperator counter) {
        int i;
        try {
            int count = 0;
            for (i = 0; i < len; ++i) {
                count += counter.applyAsInt(i);
            }
            return count;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException((array ? "array" : "tuple") + " index " + i + ": " + iae.getMessage(), iae);
        }
    }

    @Override
    public int validate(Tuple value) {
        if (value.size() == this.size()) {
            return this.countBytes(i -> TupleType.validateObject(this.getNonCapturing(i), value.elements[i]));
        }
        throw new IllegalArgumentException("tuple length mismatch: actual != expected: " + value.size() + " != " + this.size());
    }

    private static int validateObject(ABIType<Object> type, Object value) {
        try {
            type.validateClass(value);
            return TupleType.totalLen(type.validate(value), type.dynamic);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("null", npe);
        }
    }

    static int totalLen(int byteLen, boolean addUnit) {
        return addUnit ? 32 + byteLen : byteLen;
    }

    @Override
    void encodeTail(Tuple value, ByteBuffer dest) {
        TupleType.encodeObjects(this.dynamic, value.elements, this::getNonCapturing, dest, this.firstOffset);
    }

    @Override
    void encodePackedUnchecked(Tuple value, ByteBuffer dest) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.getNonCapturing(i).encodePackedUnchecked(value.elements[i], dest);
        }
    }

    static void encodeObjects(boolean dynamic, Object[] values, IntFunction<ABIType<Object>> getType, ByteBuffer dest, int offset) {
        int i;
        for (i = 0; i < values.length; ++i) {
            offset = getType.apply(i).encodeHead(values[i], dest, offset);
        }
        if (dynamic) {
            for (i = 0; i < values.length; ++i) {
                ABIType<Object> t = getType.apply(i);
                if (!t.dynamic) continue;
                t.encodeTail(values[i], dest);
            }
        }
    }

    @Override
    Tuple decode(ByteBuffer bb, byte[] unitBuffer) {
        Object[] elements = new Object[this.size()];
        TupleType.decodeObjects(this.dynamic, bb, unitBuffer, this::get, elements, true);
        return new Tuple(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(ByteBuffer bb, int ... indices) {
        bb.mark();
        try {
            if (indices.length == 1) {
                Object object = this.decodeIndex(bb, indices[0]);
                return (T)object;
            }
            Tuple tuple = this.decodeIndices(bb, indices);
            return (T)tuple;
        }
        finally {
            bb.reset();
        }
    }

    private void ensureIndexInBounds(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        if (index >= this.elementTypes.length) {
            throw new IllegalArgumentException("index " + index + " out of bounds for tuple type of length " + this.elementTypes.length);
        }
    }

    private Object decodeIndex(ByteBuffer bb, int index) {
        int start;
        this.ensureIndexInBounds(index);
        int position = start = bb.position();
        int curr = -1;
        while (++curr < index) {
            position += this.elementTypes[curr].headLength();
        }
        bb.position(position);
        return TupleType.decodeObject(this.elementTypes[index], bb, start, TupleType.newUnitBuffer(), index);
    }

    private Tuple decodeIndices(ByteBuffer bb, int ... indices) {
        Object[] results = new Object[this.elementTypes.length];
        int start = bb.position();
        byte[] unitBuffer = TupleType.newUnitBuffer();
        int position = start;
        int curr = -1;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            this.ensureIndexInBounds(index);
            if (index <= curr) {
                throw new IllegalArgumentException("index out of order: " + index);
            }
            while (++curr < index) {
                position += this.elementTypes[curr].headLength();
            }
            bb.position(position);
            ABIType<?> resultType = this.elementTypes[curr];
            results[curr] = TupleType.decodeObject(resultType, bb, start, unitBuffer, curr);
            position += resultType.headLength();
        }
        return new Tuple(results);
    }

    private static Object decodeObject(ABIType<?> type, ByteBuffer bb, int start, byte[] unitBuffer, int index) {
        try {
            if (type.dynamic) {
                bb.position(start + Encoding.UINT31.decode(bb, unitBuffer));
            }
            return type.decode(bb, unitBuffer);
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.decodeException(true, index, cause);
        }
    }

    static int staticTupleHeadLength(TupleType tt) {
        int len = 0;
        block4: for (ABIType<?> e : tt) {
            switch (e.typeCode()) {
                case 6: {
                    len += ArrayType.staticArrayHeadLength((ArrayType)e);
                    continue block4;
                }
                case 7: {
                    len += TupleType.staticTupleHeadLength((TupleType)e);
                    continue block4;
                }
            }
            len += 32;
        }
        return len;
    }

    static void decodeObjects(boolean dynamic, ByteBuffer bb, byte[] unitBuffer, IntFunction<ABIType<?>> getType, Object[] objects, boolean tuple) {
        int i = 0;
        try {
            if (!dynamic) {
                for (i = 0; i < objects.length; ++i) {
                    objects[i] = getType.apply(i).decode(bb, unitBuffer);
                }
                return;
            }
            int start = bb.position();
            int[] offsets = new int[objects.length];
            for (i = 0; i < objects.length; ++i) {
                ABIType<?> t = getType.apply(i);
                if (!t.dynamic) {
                    objects[i] = t.decode(bb, unitBuffer);
                    continue;
                }
                offsets[i] = Encoding.UINT31.decode(bb, unitBuffer);
            }
            for (i = 0; i < objects.length; ++i) {
                int offset = offsets[i];
                if (offset <= 0) continue;
                int jump = start + offset;
                if (jump != bb.position()) {
                    bb.position(jump);
                }
                objects[i] = getType.apply(i).decode(bb, unitBuffer);
            }
        }
        catch (IllegalArgumentException cause) {
            throw TupleType.decodeException(tuple, i, cause);
        }
    }

    static IllegalArgumentException decodeException(boolean tuple, int i, IllegalArgumentException cause) {
        return new IllegalArgumentException((tuple ? "tuple index " : "array index ") + i + ": " + cause.getMessage(), cause);
    }

    @Override
    public Iterator<ABIType<?>> iterator() {
        return Arrays.asList(this.elementTypes).iterator();
    }

    public TupleType select(boolean ... manifest) {
        return this.selectElements(manifest, false);
    }

    public TupleType exclude(boolean ... manifest) {
        return this.selectElements(manifest, true);
    }

    private TupleType selectElements(boolean[] manifest, boolean negate) {
        int size = this.size();
        if (manifest.length == size) {
            StringBuilder canonicalBuilder = new StringBuilder("(");
            boolean dynamic = false;
            ArrayList selected = new ArrayList(size);
            ArrayList<String> selectedNames = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                if (!(negate ^ manifest[i])) continue;
                Object e = this.get(i);
                canonicalBuilder.append(((ABIType)e).canonicalType).append(',');
                dynamic |= ((ABIType)e).dynamic;
                selected.add(e);
                selectedNames.add(this.elementNames == null ? null : this.elementNames[i]);
            }
            return new TupleType(TupleType.completeTupleTypeString(canonicalBuilder), dynamic, selected.toArray(EMPTY_ARRAY), selectedNames.toArray(EMPTY_STRING_ARRAY));
        }
        throw new IllegalArgumentException("manifest.length != size(): " + manifest.length + " != " + size);
    }

    private static String completeTupleTypeString(StringBuilder sb) {
        int len = sb.length();
        return len != 1 ? sb.deleteCharAt(len - 1).append(')').toString() : EMPTY_TUPLE_STRING;
    }

    public static TupleType parse(String rawTupleTypeString) {
        return (TupleType)TypeFactory.create(rawTupleTypeString);
    }

    public static TupleType of(String ... typeStrings) {
        StringBuilder sb = new StringBuilder("(");
        for (String str : typeStrings) {
            sb.append(str).append(',');
        }
        return TupleType.parse(TupleType.completeTupleTypeString(sb));
    }
}

