/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.Notation;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.rlp.util.FloatingPoint;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class RLPItem
implements Comparable<RLPItem> {
    public static final RLPItem[] EMPTY_ARRAY = new RLPItem[0];
    final byte[] buffer;
    public final int index;
    public final transient int dataIndex;
    public final transient int dataLength;
    public final transient int endIndex;

    RLPItem(byte[] buffer, int index, int dataIndex, int dataLength, int endIndex) {
        this.buffer = buffer;
        this.index = index;
        this.dataIndex = dataIndex;
        this.dataLength = dataLength;
        this.endIndex = endIndex;
    }

    public final DataType type() {
        return DataType.type(this.buffer[this.index]);
    }

    public boolean isString() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public RLPString asRLPString() {
        return (RLPString)this;
    }

    public RLPList asRLPList() {
        return (RLPList)this;
    }

    public abstract RLPItem duplicate();

    public final int encodingLength() {
        return this.endIndex - this.index;
    }

    public final byte[] encoding() {
        return Arrays.copyOfRange(this.buffer, this.index, this.endIndex);
    }

    public final byte[] data() {
        return Arrays.copyOfRange(this.buffer, this.dataIndex, this.endIndex);
    }

    public final int copy(byte[] dest, int destIndex) {
        int len = this.encodingLength();
        System.arraycopy(this.buffer, this.index, dest, destIndex, len);
        return destIndex + len;
    }

    public final void copy(ByteBuffer dest) {
        dest.put(this.buffer, this.index, this.encodingLength());
    }

    public final void copy(OutputStream dest) throws IOException {
        dest.write(this.buffer, this.index, this.encodingLength());
    }

    public final int copyData(byte[] dest, int destIndex) {
        System.arraycopy(this.buffer, this.dataIndex, dest, destIndex, this.dataLength);
        return destIndex + this.dataLength;
    }

    public final void copyData(ByteBuffer dest) {
        dest.put(this.buffer, this.dataIndex, this.dataLength);
    }

    public final void copyData(OutputStream dest) throws IOException {
        dest.write(this.buffer, this.dataIndex, this.dataLength);
    }

    public final byte[] asBytes() {
        return this.data();
    }

    public final String asString(int encoding) {
        return Strings.encode(this.buffer, this.dataIndex, this.dataLength, encoding);
    }

    public final boolean asBoolean() {
        return this.dataLength != 0 && this.buffer[this.index] != 0;
    }

    public final char asChar(boolean lenient) {
        return (char)this.asShort(lenient);
    }

    public final byte asByte(boolean lenient) {
        return Integers.getByte(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final short asShort(boolean lenient) {
        return Integers.getShort(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final int asInt(boolean lenient) {
        return Integers.getInt(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final long asLong(boolean lenient) {
        return Integers.getLong(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final BigInteger asBigInt(boolean lenient) {
        return Integers.getBigInt(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final float asFloat(boolean lenient) {
        return FloatingPoint.getFloat(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final double asDouble(boolean lenient) {
        return FloatingPoint.getDouble(this.buffer, this.dataIndex, this.dataLength, lenient);
    }

    public final byte asByte() {
        return this.asByte(false);
    }

    public final int asInt() {
        return this.asInt(false);
    }

    public final long asLong() {
        return this.asLong(false);
    }

    public final BigInteger asBigInt() {
        return this.asBigInt(false);
    }

    public final BigInteger asBigIntSigned() {
        return new BigInteger(this.data());
    }

    public final int hashCode() {
        int hash = 1;
        for (int i = this.index; i < this.endIndex; ++i) {
            hash = 31 * hash + this.buffer[i];
        }
        return hash;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RLPItem)) {
            return false;
        }
        RLPItem other = (RLPItem)o;
        return other.encodingLength() == this.encodingLength() && this.encodingEquals(other.buffer, other.index);
    }

    private boolean encodingEquals(byte[] oBuf, int oIdx) {
        for (int i = this.index; i < this.endIndex; ++i) {
            if (this.buffer[i] == oBuf[oIdx++]) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        return Notation.encodeToString(this.buffer, this.index, this.endIndex);
    }

    public final String encodingString(int encoding) {
        return Strings.encode(this.buffer, this.index, this.encodingLength(), encoding);
    }

    @Override
    public final int compareTo(RLPItem othr) {
        int thisOffset = this.dataIndex;
        int othrOffset = othr.dataIndex;
        int end = thisOffset + Math.min(this.dataLength, othr.dataLength);
        while (thisOffset < end) {
            byte bv;
            byte av;
            if ((av = this.buffer[thisOffset++]) == (bv = othr.buffer[othrOffset++])) continue;
            return av - bv;
        }
        return this.dataLength - othr.dataLength;
    }
}

