/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.FastBase64;
import com.esaulpaugh.headlong.util.FastHex;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class Strings {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int HEX = 0;
    public static final int UTF_8 = 1;
    public static final int BASE_64_URL_SAFE = 2;
    public static final int ASCII = 3;
    private static final int URL_SAFE_FLAGS = 7;

    private Strings() {
    }

    public static String encode(byte b) {
        return Strings.encode(new byte[]{b});
    }

    public static String encode(ByteBuffer buffer) {
        return Strings.encode(buffer.array());
    }

    public static String encode(byte[] bytes) {
        return Strings.encode(bytes, 0);
    }

    public static String encode(byte[] bytes, int encoding) {
        return Strings.encode(bytes, 0, bytes.length, encoding);
    }

    public static String encode(byte[] buffer, int from, int len, int encoding) {
        switch (encoding) {
            case 0: {
                return FastHex.encodeToString(buffer, from, len);
            }
            case 1: {
                return new String(buffer, from, len, StandardCharsets.UTF_8);
            }
            case 2: {
                return FastBase64.encodeToString(buffer, from, len, 7);
            }
            case 3: {
                return new String(buffer, from, len, StandardCharsets.US_ASCII);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] decode(String hex) {
        return Strings.decode(hex, 0);
    }

    public static byte[] decode(String str, int encoding) {
        if (str.isEmpty()) {
            return EMPTY_BYTE_ARRAY;
        }
        switch (encoding) {
            case 0: {
                return FastHex.decode(str, 0, str.length());
            }
            case 1: {
                return str.getBytes(StandardCharsets.UTF_8);
            }
            case 2: {
                return Base64.getUrlDecoder().decode(str);
            }
            case 3: {
                return str.getBytes(StandardCharsets.US_ASCII);
            }
        }
        throw new UnsupportedOperationException();
    }
}

