/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.Address;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Tuple
implements Iterable<Object> {
    public static final Tuple EMPTY = new Tuple(new Object[0]);
    private static final String SKIPPED = "_";
    final Object[] elements;

    Tuple(Object ... elements) {
        this.elements = elements;
    }

    public static Tuple of(Object ... elements) {
        Object[] shallowCopy = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            shallowCopy[i] = Tuple.requireNotNull(elements[i], i);
        }
        return new Tuple(shallowCopy);
    }

    public static Tuple singleton(Object element) {
        return new Tuple(Tuple.requireNotNull(element, 0));
    }

    private static Object requireNotNull(Object e, int index) {
        if (e == null) {
            throw new IllegalArgumentException("tuple index " + index + " is null");
        }
        return e;
    }

    public <T> T get(int index) {
        Object val = this.elements[index];
        if (val == null) {
            throw new NoSuchElementException("" + index);
        }
        return (T)val;
    }

    public boolean elementIsPresent(int index) {
        return this.elements[index] != null;
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Tuple && Arrays.deepEquals(((Tuple)o).elements, this.elements);
    }

    public String toString() {
        Object[] copy = new Object[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            copy[i] = Tuple.normalize(this.elements[i]);
        }
        return Arrays.deepToString(copy);
    }

    private static Object normalize(Object element) {
        if (element == null) {
            return SKIPPED;
        }
        return SKIPPED.equals(element.toString()) ? "\"_\"" : element;
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.elements).iterator();
    }

    public Tuple deepCopy() {
        Object[] deepCopy = new Object[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            deepCopy[i] = Tuple.deepCopyElement(this.elements[i]);
        }
        return new Tuple(deepCopy);
    }

    private static Object deepCopyElement(Object e) {
        if (e.getClass().isArray()) {
            if (e instanceof Object[]) {
                Object[] original = (Object[])e;
                Object[] copy = (Object[])Array.newInstance(Tuple.elementClass(original.getClass()), original.length);
                for (int i = 0; i < copy.length; ++i) {
                    copy[i] = Tuple.deepCopyElement(original[i]);
                }
                return copy;
            }
            if (e instanceof byte[]) {
                byte[] bytes = (byte[])e;
                return Arrays.copyOf(bytes, bytes.length);
            }
            if (e instanceof boolean[]) {
                boolean[] booleans = (boolean[])e;
                return Arrays.copyOf(booleans, booleans.length);
            }
            if (e instanceof int[]) {
                int[] ints = (int[])e;
                return Arrays.copyOf(ints, ints.length);
            }
            if (e instanceof long[]) {
                long[] longs = (long[])e;
                return Arrays.copyOf(longs, longs.length);
            }
            throw new IllegalArgumentException();
        }
        return e instanceof Tuple ? ((Tuple)e).deepCopy() : e;
    }

    private static Class<?> elementClass(Class<? extends Object[]> arrClazz) {
        try {
            if (arrClazz == BigInteger[].class) {
                return BigInteger.class;
            }
            if (arrClazz == Address[].class) {
                return Address.class;
            }
            if (arrClazz == Tuple[].class) {
                return Tuple.class;
            }
            String name = arrClazz.getName();
            if (name.charAt(0) == '[') {
                return Class.forName(name.charAt(1) == 'L' ? name.substring(2, name.length() - 1) : name.substring(1));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new AssertionError();
    }
}

