/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.util.JsonUtils;
import com.google.gson.JsonObject;
import java.util.Objects;

public final class ContractError
implements ABIObject {
    private final String name;
    private final TupleType inputs;

    public ContractError(String name, TupleType inputs) {
        this.name = Objects.requireNonNull(name);
        this.inputs = Objects.requireNonNull(inputs);
    }

    @Override
    public TypeEnum getType() {
        return TypeEnum.ERROR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleType getInputs() {
        return this.inputs;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name + this.inputs.canonicalType;
    }

    public Function function() {
        return Function.parse(this.getCanonicalSignature());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inputs);
    }

    public boolean equals(Object o) {
        if (o instanceof ContractError) {
            ContractError that = (ContractError)o;
            return this.name.equals(that.name) && this.inputs.equals(that.inputs);
        }
        return false;
    }

    public static ContractError fromJson(String errorJson) {
        return ContractError.fromJsonObject(JsonUtils.parseObject(errorJson));
    }

    public static ContractError fromJsonObject(JsonObject error) {
        return ABIJSON.parseError(error);
    }

    public String toString() {
        return this.toJson(true);
    }

    @Override
    public boolean isContractError() {
        return true;
    }
}

