/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Encoding;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class UnitType<J>
extends ABIType<J> {
    public static final int UNIT_LENGTH_BYTES = 32;
    final int bitLength;
    final boolean unsigned;

    UnitType(String canonicalType, Class<J> clazz, int bitLength, boolean unsigned) {
        super(canonicalType, clazz, false);
        this.bitLength = bitLength;
        this.unsigned = unsigned;
    }

    public final int getBitLength() {
        return this.bitLength;
    }

    public final boolean isUnsigned() {
        return this.unsigned;
    }

    public final BigInteger minValue() {
        return this.unsigned ? BigInteger.ZERO : BigInteger.valueOf(2L).pow(this.bitLength - 1).negate();
    }

    public final BigInteger maxValue() {
        return BigInteger.valueOf(2L).pow(this.unsigned ? this.bitLength : this.bitLength - 1).subtract(BigInteger.ONE);
    }

    @Override
    int headLength() {
        return 32;
    }

    @Override
    int byteLength(J value) {
        return 32;
    }

    @Override
    int byteLengthPacked(J value) {
        return this.bitLength / 8;
    }

    @Override
    public final int validate(J value) {
        this.validateClass(value);
        this.validateInternal(value);
        return 32;
    }

    void validateInternal(J value) {
        this.validatePrimitive(UnitType.toLong(value));
    }

    @Override
    void encodeTail(J value, ByteBuffer dest) {
        Encoding.insertInt(UnitType.toLong(value), dest);
    }

    @Override
    void encodePackedUnchecked(J value, ByteBuffer dest) {
        LongType.encodeLong(UnitType.toLong(value), this.byteLengthPacked(null), dest);
    }

    private static long toLong(Object value) {
        return ((Number)value).longValue();
    }

    final int validatePrimitive(long longVal) {
        if (this.unsigned) {
            if (longVal < 0L) {
                throw new IllegalArgumentException("signed value given for unsigned type");
            }
            this.checkUnsignedBitLen(Integers.bitLen(longVal));
        } else {
            this.checkSignedBitLen(Integers.bitLen(longVal < 0L ? longVal ^ 0xFFFFFFFFFFFFFFFFL : longVal));
        }
        return 32;
    }

    final void validateBigInt(BigInteger bigIntVal) {
        if (this.unsigned) {
            if (bigIntVal.signum() < 0) {
                throw new IllegalArgumentException("signed value given for unsigned type");
            }
            this.checkUnsignedBitLen(bigIntVal.bitLength());
        } else {
            this.checkSignedBitLen(bigIntVal.bitLength());
        }
    }

    private void checkUnsignedBitLen(int actual) {
        if (actual > this.bitLength) {
            throw new IllegalArgumentException("unsigned val exceeds bit limit: " + actual + " > " + this.bitLength);
        }
    }

    private void checkSignedBitLen(int actual) {
        if (actual >= this.bitLength) {
            throw new IllegalArgumentException("signed val exceeds bit limit: " + actual + " >= " + this.bitLength);
        }
    }

    final BigInteger decodeValid(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer, 0, 32);
        BigInteger bi = this.unsigned ? new BigInteger(1, unitBuffer) : new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi;
    }
}

