/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Integers;
import java.nio.charset.StandardCharsets;
import java.util.function.IntUnaryOperator;

public final class FastHex {
    public static final int CHARS_PER_BYTE = 2;
    public static final int BITS_PER_CHAR = 4;
    private static final short[] ENCODE_TABLE = new short[256];

    private FastHex() {
    }

    public static String encodeToString(byte ... buffer) {
        return FastHex.encodeToString(buffer, 0, buffer.length);
    }

    public static String encodeToString(byte[] buffer, int offset, int len) {
        byte[] enc = FastHex.encodeToBytes(buffer, offset, len);
        return new String(enc, 0, 0, enc.length);
    }

    public static byte[] encodeToBytes(byte ... buffer) {
        return FastHex.encodeToBytes(buffer, 0, buffer.length);
    }

    public static byte[] encodeToBytes(byte[] buffer, int offset, int len) {
        int end = offset + len;
        byte[] bytes = new byte[len * 2];
        int j = 0;
        while (offset < end) {
            short hexPair = ENCODE_TABLE[buffer[offset] & 0xFF];
            bytes[j] = (byte)(hexPair >>> 8);
            bytes[j + 1] = (byte)hexPair;
            ++offset;
            j += 2;
        }
        return bytes;
    }

    public static byte[] decode(String hex) {
        return FastHex.decode(hex, 0, hex.length());
    }

    public static byte[] decode(String hex, int offset, int len) {
        return FastHex.decode(offset, len, hex::charAt);
    }

    public static byte[] decode(byte[] hexBytes, int offset, int len) {
        return FastHex.decode(offset, len, o -> hexBytes[o]);
    }

    private static byte[] decode(int offset, int len, IntUnaryOperator extractor) {
        if (!Integers.isMultiple(len, 2)) {
            throw new IllegalArgumentException("len must be a multiple of two");
        }
        byte[] dest = new byte[len / 2];
        int i = 0;
        while (i < dest.length) {
            dest[i] = (byte)FastHex.decodeByte(extractor, offset);
            ++i;
            offset += 2;
        }
        return dest;
    }

    private static int decodeByte(IntUnaryOperator extractor, int offset) {
        return FastHex.decodeNibble(extractor.applyAsInt(offset), offset) << 4 | FastHex.decodeNibble(extractor.applyAsInt(++offset), offset);
    }

    private static int decodeNibble(int c, int offset) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 55;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 87;
            }
        }
        throw new IllegalArgumentException("illegal hex val @ " + offset);
    }

    static {
        byte[] chars = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < ENCODE_TABLE.length; ++i) {
            byte leftChar = chars[(i & 0xF0) >>> 4];
            byte rightChar = chars[i & 0xF];
            FastHex.ENCODE_TABLE[i] = (short)(leftChar << 8 | rightChar);
        }
    }
}

