/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.util.Integers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TypeFactory {
    static final int ADDRESS_BIT_LEN = 160;
    private static final int DECIMAL_BIT_LEN = 168;
    private static final int DECIMAL_SCALE = 10;
    private static final int FIXED_BIT_LEN = 128;
    private static final int FIXED_SCALE = 18;
    private static final int FUNCTION_BYTE_LEN = 24;
    private static final int MAX_LENGTH_CHARS = 2000;
    private static final Map<String, ABIType<?>> BASE_TYPE_MAP;

    private TypeFactory() {
    }

    static Map<String, ABIType<?>> getBaseTypeMap() {
        return Collections.unmodifiableMap(BASE_TYPE_MAP);
    }

    private static void mapInt(String type, int bitLen, boolean unsigned) {
        BASE_TYPE_MAP.put(type, new IntType(type, bitLen, unsigned));
    }

    private static void mapLong(String type, int bitLen, boolean unsigned) {
        BASE_TYPE_MAP.put(type, new LongType(type, bitLen, unsigned));
    }

    private static void mapBigInteger(String type, int bitLen, boolean unsigned) {
        BASE_TYPE_MAP.put(type, new BigIntegerType(type, bitLen, unsigned));
    }

    private static void mapByteArray(String type, int arrayLen) {
        BASE_TYPE_MAP.put(type, new ArrayType<ByteType, byte[]>(type, byte[].class, ByteType.INSTANCE, arrayLen, byte[][].class));
    }

    public static <T extends ABIType<?>> T create(String rawType) {
        return (T)TypeFactory.build(rawType, null, null);
    }

    public static ABIType<Object> createNonCapturing(String rawType) {
        return TypeFactory.build(rawType, null, null);
    }

    public static TupleType createTupleTypeWithNames(String rawType, String ... elementNames) {
        return (TupleType)TypeFactory.build(rawType, elementNames, null);
    }

    static ABIType<?> build(String rawType, String[] elementNames, ABIType<?> baseType) {
        if (rawType.length() > 2000) {
            throw new IllegalArgumentException("type length exceeds maximum: " + rawType.length() + " > " + 2000);
        }
        return TypeFactory.buildUnchecked(rawType, elementNames, baseType);
    }

    private static ABIType<?> buildUnchecked(String rawType, String[] elementNames, ABIType<?> baseType) {
        try {
            int lastCharIdx = rawType.length() - 1;
            if (rawType.charAt(lastCharIdx) == ']') {
                int secondToLastCharIdx = lastCharIdx - 1;
                int arrayOpenIndex = rawType.lastIndexOf(91, secondToLastCharIdx);
                ABIType<?> elementType = TypeFactory.buildUnchecked(rawType.substring(0, arrayOpenIndex), null, baseType);
                String type = elementType.canonicalType + rawType.substring(arrayOpenIndex);
                int length = arrayOpenIndex == secondToLastCharIdx ? -1 : TypeFactory.parseLen(rawType.substring(arrayOpenIndex + 1, lastCharIdx));
                return new ArrayType(type, elementType.arrayClass(), elementType, length, null);
            }
            if (baseType != null || (baseType = TypeFactory.resolveBaseType(rawType, elementNames)) != null) {
                return baseType;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException("unrecognized type: \"" + rawType + '\"');
    }

    private static int parseLen(String lenStr) {
        try {
            if (TypeFactory.leadDigitValid(lenStr.charAt(0)) || "0".equals(lenStr)) {
                return Integer.parseInt(lenStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("bad array length");
    }

    private static ABIType<?> resolveBaseType(String baseTypeStr, String[] elementNames) {
        if (baseTypeStr.charAt(0) == '(') {
            return TypeFactory.parseTupleType(baseTypeStr, elementNames);
        }
        BigDecimalType ret = BASE_TYPE_MAP.get(baseTypeStr);
        return ret != null ? ret : TypeFactory.tryParseFixed(baseTypeStr);
    }

    private static BigDecimalType tryParseFixed(String type) {
        int idx = type.indexOf("fixed");
        boolean unsigned = false;
        if (idx == 0 || (unsigned = idx == 1 && type.charAt(0) == 'u')) {
            int indexOfX = type.lastIndexOf(120);
            try {
                String mStr = type.substring(idx + "fixed".length(), indexOfX);
                String nStr = type.substring(indexOfX + 1);
                if (TypeFactory.leadDigitValid(mStr.charAt(0)) && TypeFactory.leadDigitValid(nStr.charAt(0))) {
                    int M = Integer.parseInt(mStr);
                    int N = Integer.parseInt(nStr);
                    if (Integers.isMultiple(M, 8) && M <= 256 && N <= 80) {
                        return new BigDecimalType((unsigned ? "ufixed" : "fixed") + M + 'x' + N, M, N, unsigned);
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean leadDigitValid(char c) {
        return c > '0' && c <= '9';
    }

    private static TupleType parseTupleType(String rawTypeStr, String[] elementNames) {
        int len = rawTypeStr.length();
        if (len == 2 && rawTypeStr.equals("()")) {
            return TupleType.EMPTY;
        }
        ArrayList elements = new ArrayList();
        int argEnd = 1;
        StringBuilder canonicalBuilder = new StringBuilder("(");
        boolean dynamic = false;
        try {
            do {
                int argStart = argEnd;
                switch (rawTypeStr.charAt(argStart)) {
                    case ')': 
                    case ',': {
                        return null;
                    }
                    case '(': {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, TypeFactory.findSubtupleEnd(rawTypeStr, argStart + 1));
                        break;
                    }
                    default: {
                        argEnd = TypeFactory.nextTerminator(rawTypeStr, argStart);
                    }
                }
                ABIType<?> e = TypeFactory.buildUnchecked(rawTypeStr.substring(argStart, argEnd), null, null);
                canonicalBuilder.append(e.canonicalType).append(',');
                dynamic |= e.dynamic;
                elements.add(e);
            } while (rawTypeStr.charAt(argEnd++) != ')');
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("@ index " + elements.size() + ", " + iae.getMessage(), iae);
        }
        if (elementNames != null && elementNames.length != elements.size()) {
            throw new IllegalArgumentException("expected " + elements.size() + " element names but found " + elementNames.length);
        }
        return argEnd == len ? new TupleType(canonicalBuilder.deleteCharAt(canonicalBuilder.length() - 1).append(')').toString(), dynamic, elements.toArray(ABIType.EMPTY_ARRAY), elementNames, null) : null;
    }

    private static int nextTerminator(String signature, int i) {
        char c;
        while ((c = signature.charAt(++i)) != ',' && c != ')') {
        }
        return i;
    }

    private static int findSubtupleEnd(String parentTypeString, int i) {
        int depth = 1;
        while (true) {
            char x;
            if ((x = parentTypeString.charAt(i)) <= ')') {
                if (x == ')') {
                    if (depth <= 1) {
                        return i;
                    }
                    --depth;
                } else if (x == '(') {
                    ++depth;
                }
            }
            ++i;
        }
    }

    static {
        int n;
        BASE_TYPE_MAP = new HashMap(256);
        for (n = 8; n <= 32; n += 8) {
            TypeFactory.mapInt("int" + n, n, false);
        }
        for (n = 40; n <= 64; n += 8) {
            TypeFactory.mapLong("int" + n, n, false);
        }
        for (n = 72; n <= 256; n += 8) {
            TypeFactory.mapBigInteger("int" + n, n, false);
        }
        for (n = 8; n <= 24; n += 8) {
            TypeFactory.mapInt("uint" + n, n, true);
        }
        for (n = 32; n <= 56; n += 8) {
            TypeFactory.mapLong("uint" + n, n, true);
        }
        for (n = 64; n <= 256; n += 8) {
            TypeFactory.mapBigInteger("uint" + n, n, true);
        }
        for (n = 1; n <= 32; ++n) {
            TypeFactory.mapByteArray("bytes" + n, n);
        }
        BASE_TYPE_MAP.put("address", new AddressType());
        TypeFactory.mapByteArray("function", 24);
        TypeFactory.mapByteArray("bytes", -1);
        BASE_TYPE_MAP.put("string", new ArrayType<ByteType, String>("string", ArrayType.STRING_CLASS, ByteType.INSTANCE, -1, ArrayType.STRING_ARRAY_CLASS));
        BASE_TYPE_MAP.put("fixed128x18", new BigDecimalType("fixed128x18", 128, 18, false));
        BASE_TYPE_MAP.put("ufixed128x18", new BigDecimalType("ufixed128x18", 128, 18, true));
        BASE_TYPE_MAP.put("fixed168x10", new BigDecimalType("fixed168x10", 168, 10, false));
        BASE_TYPE_MAP.put("decimal", BASE_TYPE_MAP.get("fixed168x10"));
        BASE_TYPE_MAP.put("int", BASE_TYPE_MAP.get("int256"));
        BASE_TYPE_MAP.put("uint", BASE_TYPE_MAP.get("uint256"));
        BASE_TYPE_MAP.put("fixed", BASE_TYPE_MAP.get("fixed128x18"));
        BASE_TYPE_MAP.put("ufixed", BASE_TYPE_MAP.get("ufixed128x18"));
        BASE_TYPE_MAP.put("bool", BooleanType.INSTANCE);
    }
}

