/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.util.GenericsUtil;
import com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public class Generics {
    private final Kryo kryo;
    private int genericTypesSize;
    private GenericType[] genericTypes = new GenericType[16];
    private final int[] depths = new int[16];
    private int argumentsSize;
    private Type[] arguments = new Type[16];

    public Generics(Kryo kryo) {
        this.kryo = kryo;
    }

    public void pushGenericType(GenericType fieldType) {
        if (fieldType.arguments == null) {
            return;
        }
        int size = this.genericTypesSize;
        if (size + 1 == this.genericTypes.length) {
            GenericType[] newArray = new GenericType[this.genericTypes.length << 1];
            System.arraycopy(this.genericTypes, 0, newArray, 0, size);
            this.genericTypes = newArray;
        }
        this.genericTypesSize = size + 1;
        this.genericTypes[size] = fieldType;
        this.depths[size] = this.kryo.getDepth();
    }

    public void popGenericType() {
        int size = this.genericTypesSize;
        if (size == 0) {
            return;
        }
        if (this.depths[--size] < this.kryo.getDepth()) {
            return;
        }
        this.genericTypes[size] = null;
        this.genericTypesSize = size;
    }

    public GenericType[] nextGenericTypes() {
        int index = this.genericTypesSize;
        if (index > 0) {
            GenericType genericType = this.genericTypes[--index];
            if (this.depths[index] == this.kryo.getDepth() - 1) {
                this.pushGenericType(genericType.arguments[genericType.arguments.length - 1]);
                return genericType.arguments;
            }
        }
        return null;
    }

    public Class nextGenericClass() {
        GenericType[] arguments = this.nextGenericTypes();
        if (arguments == null) {
            return null;
        }
        return arguments[0].resolve(this);
    }

    public int pushTypeVariables(GenericsHierarchy hierarchy, GenericType[] args) {
        int startSize = this.argumentsSize;
        int sizeNeeded = startSize + hierarchy.total;
        if (sizeNeeded > this.arguments.length) {
            Type[] newArray = new Type[Math.max(sizeNeeded, this.arguments.length << 1)];
            System.arraycopy(this.arguments, 0, newArray, 0, startSize);
            this.arguments = newArray;
        }
        int[] counts = hierarchy.counts;
        TypeVariable[] params = hierarchy.parameters;
        int p = 0;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            GenericType arg = args[i];
            Class resolved = arg.resolve(this);
            if (resolved == null) continue;
            int count = counts[i];
            if (arg == null) {
                p += count;
                continue;
            }
            int nn = p + count;
            while (p < nn) {
                this.arguments[this.argumentsSize] = params[p];
                this.arguments[this.argumentsSize + 1] = resolved;
                this.argumentsSize += 2;
                ++p;
            }
        }
        return this.argumentsSize - startSize;
    }

    public void popTypeVariables(int count) {
        int i;
        int n = this.argumentsSize;
        this.argumentsSize = i = n - count;
        while (i < n) {
            this.arguments[i++] = null;
        }
    }

    public Class resolveTypeVariable(TypeVariable typeVariable) {
        for (int i = this.argumentsSize - 2; i >= 0; i -= 2) {
            if (this.arguments[i] != typeVariable) continue;
            return (Class)this.arguments[i + 1];
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.argumentsSize; i += 2) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(((TypeVariable)this.arguments[i]).getName());
            buffer.append("=");
            buffer.append(((Class)this.arguments[i + 1]).getSimpleName());
        }
        return buffer.toString();
    }

    public static class GenericType {
        Type type;
        GenericType[] arguments;

        public GenericType(Class fromClass, Class toClass, Type context) {
            this.initialize(fromClass, toClass, context);
        }

        private void initialize(Class fromClass, Class toClass, Type context) {
            if (context instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)context;
                Class rawType = (Class)paramType.getRawType();
                this.type = rawType;
                TypeVariable<Class<T>>[] params = rawType.getTypeParameters();
                Type[] actualArgs = paramType.getActualTypeArguments();
                int n = actualArgs.length;
                this.arguments = new GenericType[n];
                for (int i = 0; i < n; ++i) {
                    this.arguments[i] = new GenericType(fromClass, toClass, actualArgs[i]);
                }
            } else if (context instanceof GenericArrayType) {
                int dimensions = 1;
                while ((context = ((GenericArrayType)context).getGenericComponentType()) instanceof GenericArrayType) {
                    ++dimensions;
                }
                this.initialize(fromClass, toClass, context);
                Type componentType = GenericsUtil.resolveType(fromClass, toClass, context);
                if (componentType instanceof Class) {
                    this.type = dimensions == 1 ? Array.newInstance((Class)componentType, 0).getClass() : Array.newInstance((Class)componentType, new int[dimensions]).getClass();
                }
            } else {
                this.type = GenericsUtil.resolveType(fromClass, toClass, context);
            }
        }

        public Class resolve(Generics generics) {
            if (this.type instanceof Class) {
                return (Class)this.type;
            }
            return generics.resolveTypeVariable((TypeVariable)this.type);
        }

        public Type getType() {
            return this.type;
        }

        public GenericType[] getTypeParameters() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(32);
            boolean array = false;
            if (this.type instanceof Class) {
                Class c = (Class)this.type;
                array = c.isArray();
                buffer.append((array ? Util.getElementClass(c) : c).getSimpleName());
                if (this.arguments != null) {
                    buffer.append('<');
                    int n = this.arguments.length;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(this.arguments[i].toString());
                    }
                    buffer.append('>');
                }
            } else {
                buffer.append(this.type.toString());
            }
            if (array) {
                int n = Util.getDimensionCount((Class)this.type);
                for (int i = 0; i < n; ++i) {
                    buffer.append("[]");
                }
            }
            return buffer.toString();
        }
    }

    public static class GenericsHierarchy {
        final int total;
        final int[] counts;
        final TypeVariable[] parameters;

        public GenericsHierarchy(Class type) {
            ArrayList temp = new ArrayList();
            TypeVariable<Class<T>>[] params = type.getTypeParameters();
            this.counts = new int[params.length];
            int total = 0;
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                TypeVariable param = params[i];
                temp.add(param);
                this.counts[i] = 1;
                Class current = type;
                block1: while (true) {
                    Type genericSuper = current.getGenericSuperclass();
                    current = current.getSuperclass();
                    if (!(genericSuper instanceof ParameterizedType)) break;
                    TypeVariable<Class<T>>[] superParams = current.getTypeParameters();
                    Type[] superArgs = ((ParameterizedType)genericSuper).getActualTypeArguments();
                    int ii = 0;
                    int nn = superArgs.length;
                    while (true) {
                        if (ii >= nn) continue block1;
                        Type superArg = superArgs[ii];
                        if (superArg == param) {
                            param = superParams[ii];
                            temp.add(param);
                            int n2 = i;
                            this.counts[n2] = this.counts[n2] + 1;
                        }
                        ++ii;
                    }
                    break;
                }
                total += this.counts[i];
            }
            this.total = total;
            this.parameters = temp.toArray(new TypeVariable[temp.size()]);
        }
    }
}

