/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.Generics;
import java.lang.reflect.Field;

class ReflectField
extends FieldSerializer.CachedField {
    final FieldSerializer fieldSerializer;
    final Generics.GenericType genericType;

    ReflectField(Field field, FieldSerializer fieldSerializer, Generics.GenericType genericType) {
        super(field);
        this.fieldSerializer = fieldSerializer;
        this.genericType = genericType;
    }

    public Object get(Object object) throws IllegalAccessException {
        return this.field.get(object);
    }

    public void set(Object object, Object value) throws IllegalAccessException {
        this.field.set(object, value);
    }

    @Override
    public void write(Output output, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value = this.get(object);
            Serializer serializer = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                if (value == null) {
                    kryo.writeClass(output, null);
                    return;
                }
                Registration registration = kryo.writeClass(output, value.getClass());
                if (serializer == null) {
                    serializer = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                kryo.writeObject(output, value, serializer);
            } else {
                if (serializer == null) {
                    serializer = kryo.getSerializer(concreteType);
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                if (this.canBeNull) {
                    kryo.writeObjectOrNull(output, value, serializer);
                } else {
                    if (value == null) {
                        throw new KryoException("Field value cannot be null when canBeNull is false: " + this.name + " (" + object.getClass().getName() + ")");
                    }
                    kryo.writeObject(output, value, serializer);
                }
            }
            kryo.getGenerics().popGenericType();
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + object.getClass().getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex;
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace(this.name + " (" + object.getClass().getName() + ")");
            throw ex;
        }
    }

    @Override
    public void read(Input input, Object object) {
        Kryo kryo = this.fieldSerializer.kryo;
        try {
            Object value;
            Serializer serializer = this.serializer;
            Class concreteType = this.resolveFieldClass();
            if (concreteType == null) {
                Registration registration = kryo.readClass(input);
                if (registration == null) {
                    this.set(object, null);
                    return;
                }
                if (serializer == null) {
                    serializer = registration.getSerializer();
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = kryo.readObject(input, registration.getType(), serializer);
            } else {
                if (serializer == null) {
                    serializer = kryo.getSerializer(concreteType);
                }
                kryo.getGenerics().pushGenericType(this.genericType);
                value = this.canBeNull ? kryo.readObjectOrNull(input, concreteType, serializer) : kryo.readObject(input, concreteType, serializer);
            }
            kryo.getGenerics().popGenericType();
            this.set(object, value);
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
    }

    Class resolveFieldClass() {
        Class fieldClass;
        if (this.valueClass == null && (fieldClass = this.genericType.resolve(this.fieldSerializer.kryo.getGenerics())) != null && this.fieldSerializer.kryo.isFinal(fieldClass)) {
            return fieldClass;
        }
        return this.valueClass;
    }

    @Override
    public void copy(Object original, Object copy) {
        try {
            this.set(copy, this.fieldSerializer.kryo.copy(this.get(original)));
        }
        catch (IllegalAccessException ex) {
            throw new KryoException("Error accessing field: " + this.name + " (" + this.fieldSerializer.type.getName() + ")", ex);
        }
        catch (KryoException ex) {
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace(this.name + " (" + this.fieldSerializer.type.getName() + ")");
            throw ex;
        }
    }

    static final class DoubleReflectField
    extends FieldSerializer.CachedField {
        public DoubleReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeDouble(this.field.getDouble(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setDouble(object, input.readDouble());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setDouble(copy, this.field.getDouble(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (double)");
                throw ex;
            }
        }
    }

    static final class LongReflectField
    extends FieldSerializer.CachedField {
        public LongReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varEncoding) {
                    output.writeVarLong(this.field.getLong(object), false);
                } else {
                    output.writeLong(this.field.getLong(object));
                }
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setLong(object, input.readVarLong(false));
                } else {
                    this.field.setLong(object, input.readLong());
                }
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setLong(copy, this.field.getLong(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (long)");
                throw ex;
            }
        }
    }

    static final class CharReflectField
    extends FieldSerializer.CachedField {
        public CharReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeChar(this.field.getChar(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setChar(object, input.readChar());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setChar(copy, this.field.getChar(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (char)");
                throw ex;
            }
        }
    }

    static final class BooleanReflectField
    extends FieldSerializer.CachedField {
        public BooleanReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeBoolean(this.field.getBoolean(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setBoolean(object, input.readBoolean());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setBoolean(copy, this.field.getBoolean(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (boolean)");
                throw ex;
            }
        }
    }

    static final class ByteReflectField
    extends FieldSerializer.CachedField {
        public ByteReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeByte(this.field.getByte(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setByte(object, input.readByte());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setByte(copy, this.field.getByte(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (byte)");
                throw ex;
            }
        }
    }

    static final class ShortReflectField
    extends FieldSerializer.CachedField {
        public ShortReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeShort(this.field.getShort(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setShort(object, input.readShort());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setShort(copy, this.field.getShort(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (short)");
                throw ex;
            }
        }
    }

    static final class FloatReflectField
    extends FieldSerializer.CachedField {
        public FloatReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                output.writeFloat(this.field.getFloat(object));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                this.field.setFloat(object, input.readFloat());
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setFloat(copy, this.field.getFloat(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (float)");
                throw ex;
            }
        }
    }

    static final class IntReflectField
    extends FieldSerializer.CachedField {
        public IntReflectField(Field field) {
            super(field);
        }

        @Override
        public void write(Output output, Object object) {
            try {
                if (this.varEncoding) {
                    output.writeVarInt(this.field.getInt(object), false);
                } else {
                    output.writeInt(this.field.getInt(object));
                }
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }

        @Override
        public void read(Input input, Object object) {
            try {
                if (this.varEncoding) {
                    this.field.setInt(object, input.readVarInt(false));
                } else {
                    this.field.setInt(object, input.readInt());
                }
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            try {
                this.field.setInt(copy, this.field.getInt(original));
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(this.name + " (int)");
                throw ex;
            }
        }
    }
}

