/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Registration;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.InputChunked;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.io.OutputChunked;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import com.esotericsoftware.kryo.kryo5.util.Util;

public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    private static final int binarySearchThreshold = 32;
    private CompatibleFieldSerializerConfig config;

    public CompatibleFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new CompatibleFieldSerializerConfig());
    }

    public CompatibleFieldSerializer(Kryo kryo, Class type, CompatibleFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        Output fieldOutput;
        int pop = this.pushTypeVariables();
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write fields for class: " + this.type.getName());
            }
            context.put(this, null);
            output.writeVarInt(fields.length, true);
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write field name: " + fields[i].name + Util.pos(output.position()));
                }
                output.writeString(fields[i].name);
            }
        }
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownFieldData;
        OutputChunked outputChunked = null;
        if (chunked) {
            outputChunked = new OutputChunked(output, this.config.chunkSize);
            fieldOutput = outputChunked;
        } else {
            fieldOutput = output;
        }
        for (FieldSerializer.CachedField cachedField : fields) {
            if (Log.TRACE) {
                this.log("Write", cachedField, output.position());
            }
            if (readUnknownTagData) {
                Class<?> valueClass = null;
                try {
                    Object value;
                    if (object != null && (value = cachedField.field.get(object)) != null) {
                        valueClass = value.getClass();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                kryo.writeClass(fieldOutput, valueClass);
                if (valueClass == null) {
                    if (!chunked) continue;
                    outputChunked.endChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
            }
            cachedField.write(fieldOutput, object);
            if (!chunked) continue;
            outputChunked.endChunk();
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        Input fieldInput;
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])kryo.getGraphContext().get(this);
        if (fields == null) {
            fields = this.readFields(kryo, input);
        }
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownFieldData;
        InputChunked inputChunked = null;
        if (chunked) {
            inputChunked = new InputChunked(input, this.config.chunkSize);
            fieldInput = inputChunked;
        } else {
            fieldInput = input;
        }
        for (FieldSerializer.CachedField cachedField : fields) {
            if (readUnknownTagData) {
                String message;
                Registration registration;
                try {
                    registration = kryo.readClass(fieldInput);
                }
                catch (KryoException ex) {
                    message = "Unable to read unknown data (unknown type). (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked) {
                        throw new KryoException(message, ex);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message, ex);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                if (registration == null) {
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                Class valueClass = registration.getType();
                if (cachedField == null) {
                    block24: {
                        if (Log.TRACE) {
                            Log.trace("kryo", "Read unknown data, type: " + Util.className(valueClass) + Util.pos(input.position()));
                        }
                        try {
                            kryo.readObject(fieldInput, valueClass);
                        }
                        catch (KryoException ex) {
                            String message2 = "Unable to read unknown data, type: " + Util.className(valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                            if (!chunked) {
                                throw new KryoException(message2, ex);
                            }
                            if (!Log.DEBUG) break block24;
                            Log.debug("kryo", message2, ex);
                        }
                    }
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                if (cachedField.valueClass != null && !Util.isAssignableTo(valueClass, cachedField.valueClass)) {
                    message = "Read type is incompatible with the field type: " + Util.className(valueClass) + " -> " + Util.className(cachedField.valueClass) + " (" + this.getType().getName() + "#" + cachedField + ")";
                    if (!chunked) {
                        throw new KryoException(message);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", message);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
            } else if (cachedField == null) {
                if (!chunked) {
                    throw new KryoException("Unknown field. (" + this.getType().getName() + ")");
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip unknown field.");
                }
                inputChunked.nextChunk();
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", cachedField, input.position());
            }
            cachedField.read(fieldInput, object);
            if (!chunked) continue;
            inputChunked.nextChunk();
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
        return object;
    }

    private FieldSerializer.CachedField[] readFields(Kryo kryo, Input input) {
        if (Log.TRACE) {
            Log.trace("kryo", "Read fields for class: " + this.type.getName());
        }
        int length = input.readVarInt(true);
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = input.readString();
            if (!Log.TRACE) continue;
            Log.trace("kryo", "Read field name: " + names[i]);
        }
        FieldSerializer.CachedField[] fields = new FieldSerializer.CachedField[length];
        FieldSerializer.CachedField[] allFields = this.cachedFields.fields;
        if (length < 32) {
            block1: for (int i = 0; i < length; ++i) {
                String schemaName = names[i];
                int nn = allFields.length;
                for (int ii = 0; ii < nn; ++ii) {
                    if (!allFields[ii].name.equals(schemaName)) continue;
                    fields[i] = allFields[ii];
                    continue block1;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Unknown field will be skipped: " + schemaName);
            }
        } else {
            int lastFieldIndex = allFields.length;
            block3: for (int i = 0; i < length; ++i) {
                String schemaName = names[i];
                int low = 0;
                int high = lastFieldIndex;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int compare = schemaName.compareTo(allFields[mid].name);
                    if (compare < 0) {
                        high = mid - 1;
                        continue;
                    }
                    if (compare > 0) {
                        low = mid + 1;
                        continue;
                    }
                    fields[i] = allFields[mid];
                    continue block3;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Unknown field will be skipped: " + schemaName);
            }
        }
        kryo.getGraphContext().put(this, fields);
        return fields;
    }

    public CompatibleFieldSerializerConfig getCompatibleFieldSerializerConfig() {
        return this.config;
    }

    public static class CompatibleFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean readUnknownFieldData = true;
        boolean chunked;
        int chunkSize = 1024;

        @Override
        public CompatibleFieldSerializerConfig clone() {
            return (CompatibleFieldSerializerConfig)super.clone();
        }

        public void setReadUnknownFieldData(boolean readUnknownTagData) {
            this.readUnknownFieldData = readUnknownTagData;
        }

        public boolean getReadUnknownTagData() {
            return this.readUnknownFieldData;
        }

        public void setChunkedEncoding(boolean chunked) {
            this.chunked = chunked;
            if (Log.TRACE) {
                Log.trace("kryo", "CompatibleFieldSerializerConfig setChunked: " + chunked);
            }
        }

        public boolean getChunkedEncoding() {
            return this.chunked;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            if (Log.TRACE) {
                Log.trace("kryo", "CompatibleFieldSerializerConfig setChunkSize: " + chunkSize);
            }
        }

        public int getChunkSize() {
            return this.chunkSize;
        }
    }
}

