/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Listener {
    public void connected(Connection connection) {
    }

    public void disconnected(Connection connection) {
    }

    public void received(Connection connection, Object object) {
    }

    public void idle(Connection connection) {
    }

    public static class LagListener
    extends QueuedListener {
        private final ScheduledExecutorService threadPool;
        private final int lagMillisMin;
        private final int lagMillisMax;
        final LinkedList<Runnable> runnables = new LinkedList();

        public LagListener(int lagMillisMin, int lagMillisMax, Listener listener) {
            super(listener);
            this.lagMillisMin = lagMillisMin;
            this.lagMillisMax = lagMillisMax;
            this.threadPool = Executors.newScheduledThreadPool(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(Runnable runnable) {
            LinkedList<Runnable> linkedList = this.runnables;
            synchronized (linkedList) {
                this.runnables.addFirst(runnable);
            }
            int lag = this.lagMillisMin + (int)(Math.random() * (double)(this.lagMillisMax - this.lagMillisMin));
            this.threadPool.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Runnable runnable;
                    LinkedList<Runnable> linkedList = LagListener.this.runnables;
                    synchronized (linkedList) {
                        runnable = LagListener.this.runnables.removeLast();
                    }
                    runnable.run();
                }
            }, (long)lag, TimeUnit.MILLISECONDS);
        }
    }

    public static class ThreadedListener
    extends QueuedListener {
        protected final ExecutorService threadPool;

        public ThreadedListener(Listener listener) {
            this(listener, Executors.newFixedThreadPool(1));
        }

        public ThreadedListener(Listener listener, ExecutorService threadPool) {
            super(listener);
            if (threadPool == null) {
                throw new IllegalArgumentException("threadPool cannot be null.");
            }
            this.threadPool = threadPool;
        }

        public void queue(Runnable runnable) {
            this.threadPool.execute(runnable);
        }
    }

    public static abstract class QueuedListener
    extends Listener {
        final Listener listener;

        public QueuedListener(Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener cannot be null.");
            }
            this.listener = listener;
        }

        public void connected(final Connection connection) {
            this.queue(new Runnable(){

                public void run() {
                    QueuedListener.this.listener.connected(connection);
                }
            });
        }

        public void disconnected(final Connection connection) {
            this.queue(new Runnable(){

                public void run() {
                    QueuedListener.this.listener.disconnected(connection);
                }
            });
        }

        public void received(final Connection connection, final Object object) {
            this.queue(new Runnable(){

                public void run() {
                    QueuedListener.this.listener.received(connection, object);
                }
            });
        }

        public void idle(final Connection connection) {
            this.queue(new Runnable(){

                public void run() {
                    QueuedListener.this.listener.idle(connection);
                }
            });
        }

        protected abstract void queue(Runnable var1);
    }

    public static class ReflectionListener
    extends Listener {
        private final HashMap<Class, Method> classToMethod = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void received(Connection connection, Object object) {
            Class<?> type = object.getClass();
            Method method = this.classToMethod.get(type);
            if (method == null) {
                if (this.classToMethod.containsKey(type)) {
                    return;
                }
                try {
                    method = this.getClass().getMethod("received", Connection.class, type);
                }
                catch (SecurityException ex) {
                    if (Log.ERROR) {
                        Log.error((String)"kryonet", (String)("Unable to access method: received(Connection, " + type.getName() + ")"), (Throwable)ex);
                    }
                    return;
                }
                catch (NoSuchMethodException ex) {
                    if (Log.DEBUG) {
                        Log.debug((String)"kryonet", (String)("Unable to find listener method: " + this.getClass().getName() + "#received(Connection, " + type.getName() + ")"));
                    }
                    return;
                }
                finally {
                    this.classToMethod.put(type, method);
                }
            }
            try {
                method.invoke((Object)this, connection, object);
            }
            catch (Throwable ex) {
                if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("Error invoking method: " + this.getClass().getName() + "#received(Connection, " + type.getName() + ")", ex);
            }
        }
    }
}

