/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.xmlxsd.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.event.xml.SchemaUtil;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;

public class SchemaUtilXerces {
    protected static QName simpleTypeToQName(short type) {
        switch (type) {
            case 2: {
                return XPathConstants.BOOLEAN;
            }
            case 5: {
                return XPathConstants.NUMBER;
            }
            case 1: {
                return XPathConstants.STRING;
            }
            case 3: {
                return XPathConstants.NUMBER;
            }
            case 4: {
                return XPathConstants.NUMBER;
            }
            case 7: {
                return XPathConstants.STRING;
            }
            case 9: {
                return XPathConstants.STRING;
            }
            case 8: {
                return XPathConstants.STRING;
            }
        }
        throw new EPException("Unexpected schema simple type encountered '" + type + "'");
    }

    public static EPTypeClass toReturnType(short xsType, String typeName, Integer optionalFractionDigits) {
        EPTypeClass result;
        if (typeName != null && (result = (EPTypeClass)SchemaUtil.TYPE_MAP.get(typeName)) != null) {
            return result;
        }
        switch (xsType) {
            case 2: {
                return EPTypePremade.BOOLEANBOXED.getEPType();
            }
            case 1: {
                return EPTypePremade.STRING.getEPType();
            }
            case 3: {
                if (optionalFractionDigits != null && optionalFractionDigits > 0) {
                    return EPTypePremade.DOUBLEBOXED.getEPType();
                }
                return EPTypePremade.INTEGERBOXED.getEPType();
            }
            case 4: {
                return EPTypePremade.FLOATBOXED.getEPType();
            }
            case 5: {
                return EPTypePremade.DOUBLEBOXED.getEPType();
            }
        }
        return EPTypePremade.STRING.getEPType();
    }
}

