/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommon;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompiler;
import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntime;
import com.espertech.esper.common.internal.util.ConfigurationParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Configuration
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final long serialVersionUID = -2806573144337726660L;
    private ConfigurationCommon common;
    private ConfigurationCompiler compiler;
    private ConfigurationRuntime runtime;
    protected static final String ESPER_DEFAULT_CONFIG = "esper.cfg.xml";

    public Configuration() {
        this.reset();
    }

    public Configuration configure() throws EPException {
        this.configure("/esper.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("Configuring from resource: " + resource);
        }
        InputStream stream = Configuration.getConfigurationInputStream(resource);
        ConfigurationParser.doConfigure(this, stream, resource);
        return this;
    }

    protected static InputStream getConfigurationInputStream(String resource) throws EPException {
        return Configuration.getResourceAsStream(resource);
    }

    public Configuration configure(URL url) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from url: " + url.toString());
        }
        try {
            ConfigurationParser.doConfigure(this, url.openStream(), url.toString());
            return this;
        }
        catch (IOException ioe) {
            throw new EPException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from file: " + configFile.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            ConfigurationParser.doConfigure(this, inputStream, configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new EPException("could not find file: " + configFile, fnfe);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug("Error closing input stream", (Throwable)e);
                }
            }
        }
        return this;
    }

    public Configuration configure(Document document) throws EPException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from XML document");
        }
        ConfigurationParser.doConfigure(this, document);
        return this;
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Configuration.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = Configuration.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new EPException(resource + " not found");
        }
        return stream;
    }

    public ConfigurationCommon getCommon() {
        return this.common;
    }

    public void setCommon(ConfigurationCommon common) {
        this.common = common;
    }

    public ConfigurationCompiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(ConfigurationCompiler compiler) {
        this.compiler = compiler;
    }

    public ConfigurationRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(ConfigurationRuntime runtime) {
        this.runtime = runtime;
    }

    protected void reset() {
        this.common = new ConfigurationCommon();
        this.compiler = new ConfigurationCompiler();
        this.runtime = new ConfigurationRuntime();
    }
}

