/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.compiler;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerByteCode;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExecution;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExpression;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerLanguage;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerLogging;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInDateTimeMethod;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInEnumMethod;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInPatternObject;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInView;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInVirtualDataWindow;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerScripts;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerSerde;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerStreamSelection;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerViewResources;
import com.espertech.esper.common.client.util.PatternObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationCompiler
implements Serializable {
    private static final long serialVersionUID = -1168467295251839905L;
    protected List<ConfigurationCompilerPlugInView> plugInViews;
    protected List<ConfigurationCompilerPlugInVirtualDataWindow> plugInVirtualDataWindows;
    protected List<ConfigurationCompilerPlugInPatternObject> plugInPatternObjects;
    protected List<ConfigurationCompilerPlugInAggregationFunction> plugInAggregationFunctions;
    protected List<ConfigurationCompilerPlugInAggregationMultiFunction> plugInAggregationMultiFunctions;
    protected List<ConfigurationCompilerPlugInSingleRowFunction> plugInSingleRowFunctions;
    protected List<ConfigurationCompilerPlugInDateTimeMethod> plugInDateTimeMethods;
    protected List<ConfigurationCompilerPlugInEnumMethod> plugInEnumMethods;
    private ConfigurationCompilerByteCode byteCode;
    private ConfigurationCompilerStreamSelection streamSelection;
    private ConfigurationCompilerViewResources viewResources;
    private ConfigurationCompilerLogging logging;
    private ConfigurationCompilerExpression expression;
    private ConfigurationCompilerExecution execution;
    private ConfigurationCompilerScripts scripts;
    private ConfigurationCompilerLanguage language;
    private ConfigurationCompilerSerde serde;

    public ConfigurationCompiler() {
        this.reset();
    }

    public void addPlugInAggregationFunctionForge(String functionName, String aggregationForgeClassName) {
        ConfigurationCompilerPlugInAggregationFunction entry = new ConfigurationCompilerPlugInAggregationFunction();
        entry.setName(functionName);
        entry.setForgeClassName(aggregationForgeClassName);
        this.plugInAggregationFunctions.add(entry);
    }

    public void addPlugInAggregationMultiFunction(ConfigurationCompilerPlugInAggregationMultiFunction config) {
        this.plugInAggregationMultiFunctions.add(config);
    }

    public void addPlugInSingleRowFunction(ConfigurationCompilerPlugInSingleRowFunction singleRowFunction) {
        this.plugInSingleRowFunctions.add(singleRowFunction);
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName) {
        this.addPlugInSingleRowFunction(functionName, className, methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache.DISABLED);
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache valueCache) {
        this.addPlugInSingleRowFunction(functionName, className, methodName, valueCache, ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.ENABLED);
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable filterOptimizable) {
        this.addPlugInSingleRowFunction(functionName, className, methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache.DISABLED, filterOptimizable);
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache valueCache, ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable filterOptimizable) {
        this.addPlugInSingleRowFunction(functionName, className, methodName, valueCache, filterOptimizable, false);
    }

    public void addPlugInSingleRowFunction(String functionName, String className, String methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache valueCache, ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions) {
        ConfigurationCompilerPlugInSingleRowFunction entry = new ConfigurationCompilerPlugInSingleRowFunction();
        entry.setFunctionClassName(className);
        entry.setFunctionMethodName(methodName);
        entry.setName(functionName);
        entry.setValueCache(valueCache);
        entry.setFilterOptimizable(filterOptimizable);
        entry.setRethrowExceptions(rethrowExceptions);
        this.addPlugInSingleRowFunction(entry);
    }

    public List<ConfigurationCompilerPlugInView> getPlugInViews() {
        return this.plugInViews;
    }

    public List<ConfigurationCompilerPlugInVirtualDataWindow> getPlugInVirtualDataWindows() {
        return this.plugInVirtualDataWindows;
    }

    public List<ConfigurationCompilerPlugInAggregationFunction> getPlugInAggregationFunctions() {
        return this.plugInAggregationFunctions;
    }

    public List<ConfigurationCompilerPlugInAggregationMultiFunction> getPlugInAggregationMultiFunctions() {
        return this.plugInAggregationMultiFunctions;
    }

    public List<ConfigurationCompilerPlugInSingleRowFunction> getPlugInSingleRowFunctions() {
        return this.plugInSingleRowFunctions;
    }

    public List<ConfigurationCompilerPlugInPatternObject> getPlugInPatternObjects() {
        return this.plugInPatternObjects;
    }

    public void addPlugInView(String namespace, String name, String viewForgeClass) {
        ConfigurationCompilerPlugInView configurationPlugInView = new ConfigurationCompilerPlugInView();
        configurationPlugInView.setNamespace(namespace);
        configurationPlugInView.setName(name);
        configurationPlugInView.setForgeClassName(viewForgeClass);
        this.plugInViews.add(configurationPlugInView);
    }

    public void addPlugInVirtualDataWindow(String namespace, String name, String forgeClass) {
        this.addPlugInVirtualDataWindow(namespace, name, forgeClass, null);
    }

    public void addPlugInVirtualDataWindow(String namespace, String name, String forgeClass, Serializable customConfigurationObject) {
        ConfigurationCompilerPlugInVirtualDataWindow configurationPlugInVirtualDataWindow = new ConfigurationCompilerPlugInVirtualDataWindow();
        configurationPlugInVirtualDataWindow.setNamespace(namespace);
        configurationPlugInVirtualDataWindow.setName(name);
        configurationPlugInVirtualDataWindow.setForgeClassName(forgeClass);
        configurationPlugInVirtualDataWindow.setConfig(customConfigurationObject);
        this.plugInVirtualDataWindows.add(configurationPlugInVirtualDataWindow);
    }

    public void addPlugInPatternObserver(String namespace, String name, String observerForgeClass) {
        ConfigurationCompilerPlugInPatternObject entry = new ConfigurationCompilerPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setForgeClassName(observerForgeClass);
        entry.setPatternObjectType(PatternObjectType.OBSERVER);
        this.plugInPatternObjects.add(entry);
    }

    public void addPlugInPatternGuard(String namespace, String name, String guardForgeClass) {
        ConfigurationCompilerPlugInPatternObject entry = new ConfigurationCompilerPlugInPatternObject();
        entry.setNamespace(namespace);
        entry.setName(name);
        entry.setForgeClassName(guardForgeClass);
        entry.setPatternObjectType(PatternObjectType.GUARD);
        this.plugInPatternObjects.add(entry);
    }

    public ConfigurationCompilerByteCode getByteCode() {
        return this.byteCode;
    }

    public void setByteCode(ConfigurationCompilerByteCode byteCode) {
        this.byteCode = byteCode;
    }

    public ConfigurationCompilerStreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public ConfigurationCompilerViewResources getViewResources() {
        return this.viewResources;
    }

    public ConfigurationCompilerLogging getLogging() {
        return this.logging;
    }

    public ConfigurationCompilerExpression getExpression() {
        return this.expression;
    }

    public ConfigurationCompilerExecution getExecution() {
        return this.execution;
    }

    public ConfigurationCompilerScripts getScripts() {
        return this.scripts;
    }

    public void setScripts(ConfigurationCompilerScripts scripts) {
        this.scripts = scripts;
    }

    public ConfigurationCompilerLanguage getLanguage() {
        return this.language;
    }

    public ConfigurationCompilerSerde getSerde() {
        return this.serde;
    }

    public void setSerde(ConfigurationCompilerSerde serde) {
        this.serde = serde;
    }

    public void addPlugInDateTimeMethod(String dateTimeMethodName, String dateTimeMethodForgeFactoryClassName) {
        this.plugInDateTimeMethods.add(new ConfigurationCompilerPlugInDateTimeMethod(dateTimeMethodName, dateTimeMethodForgeFactoryClassName));
    }

    public void addPlugInEnumMethod(String enumMethodName, String enumMethodForgeFactoryClassName) {
        this.plugInEnumMethods.add(new ConfigurationCompilerPlugInEnumMethod(enumMethodName, enumMethodForgeFactoryClassName));
    }

    public List<ConfigurationCompilerPlugInDateTimeMethod> getPlugInDateTimeMethods() {
        return this.plugInDateTimeMethods;
    }

    public List<ConfigurationCompilerPlugInEnumMethod> getPlugInEnumMethods() {
        return this.plugInEnumMethods;
    }

    protected void reset() {
        this.plugInViews = new ArrayList<ConfigurationCompilerPlugInView>();
        this.plugInVirtualDataWindows = new ArrayList<ConfigurationCompilerPlugInVirtualDataWindow>();
        this.plugInAggregationFunctions = new ArrayList<ConfigurationCompilerPlugInAggregationFunction>();
        this.plugInAggregationMultiFunctions = new ArrayList<ConfigurationCompilerPlugInAggregationMultiFunction>();
        this.plugInSingleRowFunctions = new ArrayList<ConfigurationCompilerPlugInSingleRowFunction>();
        this.plugInDateTimeMethods = new ArrayList<ConfigurationCompilerPlugInDateTimeMethod>();
        this.plugInEnumMethods = new ArrayList<ConfigurationCompilerPlugInEnumMethod>();
        this.plugInPatternObjects = new ArrayList<ConfigurationCompilerPlugInPatternObject>();
        this.byteCode = new ConfigurationCompilerByteCode();
        this.streamSelection = new ConfigurationCompilerStreamSelection();
        this.viewResources = new ConfigurationCompilerViewResources();
        this.logging = new ConfigurationCompilerLogging();
        this.expression = new ConfigurationCompilerExpression();
        this.execution = new ConfigurationCompilerExecution();
        this.scripts = new ConfigurationCompilerScripts();
        this.language = new ConfigurationCompilerLanguage();
        this.serde = new ConfigurationCompilerSerde();
    }
}

