/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.runtime;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntime;
import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntimeMetricsReporting;
import com.espertech.esper.common.client.util.FilterServiceProfile;
import com.espertech.esper.common.client.util.Locking;
import com.espertech.esper.common.client.util.TimeSourceType;
import com.espertech.esper.common.client.util.UndeployRethrowPolicy;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.type.StringPatternSetLike;
import com.espertech.esper.common.internal.type.StringPatternSetRegex;
import com.espertech.esper.common.internal.util.DOMElementIterator;
import com.espertech.esper.common.internal.util.DOMUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class ConfigurationRuntimeParser {
    public static void doConfigure(ConfigurationRuntime runtime, Element runtimeElement) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(runtimeElement.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("plugin-loader")) {
                ConfigurationRuntimeParser.handlePluginLoaders(runtime, element);
                continue;
            }
            if (nodeName.equals("threading")) {
                ConfigurationRuntimeParser.handleThreading(runtime, element);
                continue;
            }
            if (nodeName.equals("logging")) {
                ConfigurationRuntimeParser.handleLogging(runtime, element);
                continue;
            }
            if (nodeName.equals("variables")) {
                ConfigurationRuntimeParser.handleVariables(runtime, element);
                continue;
            }
            if (nodeName.equals("time-source")) {
                ConfigurationRuntimeParser.handleTimeSource(runtime, element);
                continue;
            }
            if (nodeName.equals("metrics-reporting")) {
                ConfigurationRuntimeParser.handleMetricsReporting(runtime, element);
                continue;
            }
            if (nodeName.equals("exceptionHandling")) {
                ConfigurationRuntimeParser.handleExceptionHandling(runtime, element);
                continue;
            }
            if (nodeName.equals("conditionHandling")) {
                ConfigurationRuntimeParser.handleConditionHandling(runtime, element);
                continue;
            }
            if (nodeName.equals("patterns")) {
                ConfigurationRuntimeParser.handlePatterns(runtime, element);
                continue;
            }
            if (nodeName.equals("match-recognize")) {
                ConfigurationRuntimeParser.handleMatchRecognize(runtime, element);
                continue;
            }
            if (nodeName.equals("expression")) {
                ConfigurationRuntimeParser.handleExpression(runtime, element);
                continue;
            }
            if (!nodeName.equals("execution")) continue;
            ConfigurationRuntimeParser.handleExecution(runtime, element);
        }
    }

    private static void handleExecution(ConfigurationRuntime runtime, Element parentElement) {
        String declExprValueCacheSizeStr;
        DOMUtil.parseOptionalBoolean(parentElement, "prioritized", b -> runtime.getExecution().setPrioritized((boolean)b));
        DOMUtil.parseOptionalBoolean(parentElement, "fairlock", b -> runtime.getExecution().setFairlock((boolean)b));
        DOMUtil.parseOptionalBoolean(parentElement, "disable-locking", b -> runtime.getExecution().setDisableLocking((boolean)b));
        String filterServiceProfileStr = DOMUtil.getOptionalAttribute(parentElement, "filter-service-profile");
        if (filterServiceProfileStr != null) {
            FilterServiceProfile profile = FilterServiceProfile.valueOf(filterServiceProfileStr.toUpperCase(Locale.ENGLISH));
            runtime.getExecution().setFilterServiceProfile(profile);
        }
        if ((declExprValueCacheSizeStr = DOMUtil.getOptionalAttribute(parentElement, "declared-expr-value-cache-size")) != null) {
            runtime.getExecution().setDeclaredExprValueCacheSize(Integer.parseInt(declExprValueCacheSizeStr));
        }
    }

    private static void handleExpression(ConfigurationRuntime runtime, Element element) {
        DOMUtil.parseOptionalBoolean(element, "self-subselect-preeval", b -> runtime.getExpression().setSelfSubselectPreeval((boolean)b));
        String timeZoneStr = DOMUtil.getOptionalAttribute(element, "time-zone");
        if (timeZoneStr != null) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
            runtime.getExpression().setTimeZone(timeZone);
        }
    }

    private static void handleMatchRecognize(ConfigurationRuntime runtime, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("max-state")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            runtime.getMatchRecognize().setMaxStates(value);
            String preventText = DOMUtil.getOptionalAttribute(subElement, "prevent-start");
            if (preventText == null) continue;
            runtime.getMatchRecognize().setMaxStatesPreventStart(Boolean.parseBoolean(preventText));
        }
    }

    private static void handlePatterns(ConfigurationRuntime runtime, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("max-subexpression")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            runtime.getPatterns().setMaxSubexpressions(value);
            String preventText = DOMUtil.getOptionalAttribute(subElement, "prevent-start");
            if (preventText == null) continue;
            runtime.getPatterns().setMaxSubexpressionPreventStart(Boolean.parseBoolean(preventText));
        }
    }

    private static void handleConditionHandling(ConfigurationRuntime runtime, Element element) {
        runtime.getConditionHandling().addClasses(ConfigurationRuntimeParser.getHandlerFactories(element));
    }

    private static void handleExceptionHandling(ConfigurationRuntime runtime, Element element) {
        runtime.getExceptionHandling().addClasses(ConfigurationRuntimeParser.getHandlerFactories(element));
        String enableUndeployRethrowStr = DOMUtil.getOptionalAttribute(element, "undeploy-rethrow-policy");
        if (enableUndeployRethrowStr != null) {
            runtime.getExceptionHandling().setUndeployRethrowPolicy(UndeployRethrowPolicy.valueOf(enableUndeployRethrowStr.toUpperCase(Locale.ENGLISH)));
        }
    }

    private static void handleMetricsReporting(ConfigurationRuntime runtime, Element element) {
        String jmxRuntimeMetrics;
        String threading;
        String statementInterval;
        DOMUtil.parseOptionalBoolean(element, "enabled", b -> runtime.getMetricsReporting().setEnableMetricsReporting((boolean)b));
        String runtimeInterval = DOMUtil.getOptionalAttribute(element, "runtime-interval");
        if (runtimeInterval != null) {
            runtime.getMetricsReporting().setRuntimeInterval(Long.parseLong(runtimeInterval));
        }
        if ((statementInterval = DOMUtil.getOptionalAttribute(element, "statement-interval")) != null) {
            runtime.getMetricsReporting().setStatementInterval(Long.parseLong(statementInterval));
        }
        if ((threading = DOMUtil.getOptionalAttribute(element, "threading")) != null) {
            runtime.getMetricsReporting().setThreading(Boolean.parseBoolean(threading));
        }
        if ((jmxRuntimeMetrics = DOMUtil.getOptionalAttribute(element, "jmx-runtime-metrics")) != null) {
            runtime.getMetricsReporting().setJmxRuntimeMetrics(Boolean.parseBoolean(jmxRuntimeMetrics));
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            String reportInactive;
            String numStmts;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stmtgroup")) continue;
            String name = DOMUtil.getRequiredAttribute(subElement, "name");
            long interval = Long.parseLong(DOMUtil.getRequiredAttribute(subElement, "interval"));
            ConfigurationRuntimeMetricsReporting.StmtGroupMetrics metrics = new ConfigurationRuntimeMetricsReporting.StmtGroupMetrics();
            metrics.setInterval(interval);
            runtime.getMetricsReporting().addStmtGroup(name, metrics);
            String defaultInclude = DOMUtil.getOptionalAttribute(subElement, "default-include");
            if (defaultInclude != null) {
                metrics.setDefaultInclude(Boolean.parseBoolean(defaultInclude));
            }
            if ((numStmts = DOMUtil.getOptionalAttribute(subElement, "num-stmts")) != null) {
                metrics.setNumStatements(Integer.parseInt(numStmts));
            }
            if ((reportInactive = DOMUtil.getOptionalAttribute(subElement, "report-inactive")) != null) {
                metrics.setReportInactive(Boolean.parseBoolean(reportInactive));
            }
            ConfigurationRuntimeParser.handleMetricsReportingPatterns(metrics, subElement);
        }
    }

    private static void handleTimeSource(ConfigurationRuntime runtime, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            TimeSourceType timeSourceType;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("time-source-type")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for time-source element");
            }
            if (valueText.toUpperCase(Locale.ENGLISH).trim().equals("NANO")) {
                timeSourceType = TimeSourceType.NANO;
            } else if (valueText.toUpperCase(Locale.ENGLISH).trim().equals("MILLI")) {
                timeSourceType = TimeSourceType.MILLI;
            } else {
                throw new ConfigurationException("Value attribute for time-source element invalid, expected one of the following keywords: nano, milli");
            }
            runtime.getTimeSource().setTimeSourceType(timeSourceType);
        }
    }

    private static void handleVariables(ConfigurationRuntime runtime, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("msec-version-release")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            runtime.getVariables().setMsecVersionRelease(value);
        }
    }

    private static void handleLogging(ConfigurationRuntime runtime, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("execution-path")) {
                valueText = DOMUtil.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                runtime.getLogging().setEnableExecutionDebug(value);
            }
            if (subElement.getNodeName().equals("timer-debug")) {
                valueText = DOMUtil.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                runtime.getLogging().setEnableTimerDebug(value);
            }
            if (!subElement.getNodeName().equals("audit")) continue;
            runtime.getLogging().setAuditPattern(DOMUtil.getOptionalAttribute(subElement, "pattern"));
        }
    }

    private static void handleThreading(ConfigurationRuntime runtime, Element element) {
        DOMUtil.parseOptionalBoolean(element, "runtime-fairlock", b -> runtime.getThreading().setRuntimeFairlock((boolean)b));
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            ThreadPoolConfig result;
            String value;
            Long timeoutMSec;
            String timeoutMSecText;
            Boolean preserveOrder;
            String preserveOrderText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("listener-dispatch")) {
                preserveOrderText = DOMUtil.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                runtime.getThreading().setListenerDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    runtime.getThreading().setListenerDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    runtime.getThreading().setListenerDispatchLocking(Locking.valueOf(value.toUpperCase(Locale.ENGLISH)));
                }
            }
            if (subElement.getNodeName().equals("insert-into-dispatch")) {
                preserveOrderText = DOMUtil.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                runtime.getThreading().setInsertIntoDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    runtime.getThreading().setInsertIntoDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    runtime.getThreading().setInsertIntoDispatchLocking(Locking.valueOf(value.toUpperCase(Locale.ENGLISH)));
                }
            }
            if (subElement.getNodeName().equals("named-window-consumer-dispatch")) {
                preserveOrderText = DOMUtil.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                runtime.getThreading().setNamedWindowConsumerDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    runtime.getThreading().setNamedWindowConsumerDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    runtime.getThreading().setNamedWindowConsumerDispatchLocking(Locking.valueOf(value.toUpperCase(Locale.ENGLISH)));
                }
            }
            if (subElement.getNodeName().equals("internal-timer")) {
                String enabledText = DOMUtil.getRequiredAttribute(subElement, "enabled");
                Boolean enabled = Boolean.parseBoolean(enabledText);
                String msecResolutionText = DOMUtil.getRequiredAttribute(subElement, "msec-resolution");
                Long msecResolution = Long.parseLong(msecResolutionText);
                runtime.getThreading().setInternalTimerEnabled(enabled);
                runtime.getThreading().setInternalTimerMsecResolution(msecResolution);
            }
            if (subElement.getNodeName().equals("threadpool-inbound")) {
                result = ConfigurationRuntimeParser.parseThreadPoolConfig(subElement);
                runtime.getThreading().setThreadPoolInbound(result.isEnabled());
                runtime.getThreading().setThreadPoolInboundNumThreads(result.getNumThreads());
                runtime.getThreading().setThreadPoolInboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-outbound")) {
                result = ConfigurationRuntimeParser.parseThreadPoolConfig(subElement);
                runtime.getThreading().setThreadPoolOutbound(result.isEnabled());
                runtime.getThreading().setThreadPoolOutboundNumThreads(result.getNumThreads());
                runtime.getThreading().setThreadPoolOutboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-timerexec")) {
                result = ConfigurationRuntimeParser.parseThreadPoolConfig(subElement);
                runtime.getThreading().setThreadPoolTimerExec(result.isEnabled());
                runtime.getThreading().setThreadPoolTimerExecNumThreads(result.getNumThreads());
                runtime.getThreading().setThreadPoolTimerExecCapacity(result.getCapacity());
            }
            if (!subElement.getNodeName().equals("threadpool-routeexec")) continue;
            result = ConfigurationRuntimeParser.parseThreadPoolConfig(subElement);
            runtime.getThreading().setThreadPoolRouteExec(result.isEnabled());
            runtime.getThreading().setThreadPoolRouteExecNumThreads(result.getNumThreads());
            runtime.getThreading().setThreadPoolRouteExecCapacity(result.getCapacity());
        }
    }

    private static void handlePluginLoaders(ConfigurationRuntime configuration, Element element) {
        String loaderName = DOMUtil.getRequiredAttribute(element, "name");
        String className = DOMUtil.getRequiredAttribute(element, "class-name");
        Properties properties = new Properties();
        String configXML = null;
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("init-arg")) {
                String name = DOMUtil.getRequiredAttribute(subElement, "name");
                String value = DOMUtil.getRequiredAttribute(subElement, "value");
                properties.put(name, value);
            }
            if (!subElement.getNodeName().equals("config-xml")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "' :" + e.getMessage(), e);
            }
            configXML = output.toString();
        }
        configuration.addPluginLoader(loaderName, className, properties, configXML);
    }

    private static ThreadPoolConfig parseThreadPoolConfig(Element parentElement) {
        String enabled = DOMUtil.getRequiredAttribute(parentElement, "enabled");
        boolean isEnabled = Boolean.parseBoolean(enabled);
        String numThreadsStr = DOMUtil.getRequiredAttribute(parentElement, "num-threads");
        int numThreads = Integer.parseInt(numThreadsStr);
        String capacityStr = DOMUtil.getOptionalAttribute(parentElement, "capacity");
        Integer capacity = null;
        if (capacityStr != null) {
            capacity = Integer.parseInt(capacityStr);
        }
        return new ThreadPoolConfig(isEnabled, numThreads, capacity);
    }

    private static void handleMetricsReportingPatterns(ConfigurationRuntimeMetricsReporting.StmtGroupMetrics groupDef, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            String text;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("include-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), true));
            }
            if (subElement.getNodeName().equals("exclude-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), false));
            }
            if (subElement.getNodeName().equals("include-like")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), true));
            }
            if (!subElement.getNodeName().equals("exclude-like")) continue;
            text = subElement.getChildNodes().item(0).getTextContent();
            groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), false));
        }
    }

    private static List<String> getHandlerFactories(Element parentElement) {
        ArrayList<String> list = new ArrayList<String>();
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("handlerFactory")) continue;
            String text = DOMUtil.getRequiredAttribute(subElement, "class");
            list.add(text);
        }
        return list;
    }

    private static class ThreadPoolConfig {
        private boolean enabled;
        private int numThreads;
        private Integer capacity;

        public ThreadPoolConfig(boolean enabled, int numThreads, Integer capacity) {
            this.enabled = enabled;
            this.numThreads = numThreads;
            this.capacity = capacity;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public Integer getCapacity() {
            return this.capacity;
        }
    }
}

