/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.serde;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.serde.SerdeProvision;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeEmptyCtor;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.util.MethodResolver;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchCtorException;

public class SerdeProvisionByClass
extends SerdeProvision {
    private final Class serdeClass;

    public SerdeProvisionByClass(Class serdeClass) {
        this.serdeClass = serdeClass;
    }

    public Class getSerdeClass() {
        return this.serdeClass;
    }

    @Override
    public DataInputOutputSerdeForge toForge() {
        try {
            this.serdeClass.getField("INSTANCE");
            return new DataInputOutputSerdeForgeSingleton(this.serdeClass);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                MethodResolver.resolveCtor(this.serdeClass, new Class[0]);
                return new DataInputOutputSerdeForgeEmptyCtor(this.serdeClass);
            }
            catch (MethodResolverNoSuchCtorException methodResolverNoSuchCtorException) {
                throw new EPException("Serde class '" + this.serdeClass.getName() + "' does not have a singleton-style INSTANCE field or default constructor");
            }
        }
    }
}

