/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import com.espertech.esper.common.internal.type.BitWiseOpEnum;
import java.io.StringWriter;

public class BitwiseOpExpression
extends ExpressionBase {
    private BitWiseOpEnum binaryOp;
    private static final long serialVersionUID = 5564205980185587363L;

    public BitwiseOpExpression() {
    }

    public BitwiseOpExpression(BitWiseOpEnum binaryOp) {
        this.binaryOp = binaryOp;
    }

    public BitwiseOpExpression add(String property) {
        this.getChildren().add(new PropertyValueExpression(property));
        return this;
    }

    public BitwiseOpExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public BitwiseOpExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.BITWISE;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        boolean isFirst = true;
        for (Expression child : this.getChildren()) {
            if (!isFirst) {
                writer.write(this.binaryOp.getExpressionText());
            }
            child.toEPL(writer, this.getPrecedence());
            isFirst = false;
        }
    }

    public BitWiseOpEnum getBinaryOp() {
        return this.binaryOp;
    }

    public void setBinaryOp(BitWiseOpEnum binaryOp) {
        this.binaryOp = binaryOp;
    }
}

