/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class CaseWhenThenExpression
extends ExpressionBase {
    private static final long serialVersionUID = -6478192972183336030L;

    public CaseWhenThenExpression add(Expression when, Expression then) {
        int size = this.getChildren().size();
        if (size % 2 == 0) {
            this.addChild(when);
            this.addChild(then);
        } else {
            this.getChildren().add(this.getChildren().size() - 1, when);
            this.getChildren().add(this.getChildren().size() - 1, then);
        }
        return this;
    }

    public CaseWhenThenExpression setElse(Expression elseExpr) {
        int size = this.getChildren().size();
        if (size % 2 != 0) {
            this.getChildren().remove(size - 1);
        }
        this.addChild(elseExpr);
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.CASE;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        int index;
        writer.write("case");
        for (index = 0; index < this.getChildren().size() - 1; ++index) {
            writer.write(" when ");
            this.getChildren().get(index).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            if (++index == this.getChildren().size()) {
                throw new IllegalStateException("Invalid case-when expression, count of when-to-then nodes not matching");
            }
            writer.write(" then ");
            this.getChildren().get(index).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (index < this.getChildren().size()) {
            writer.write(" else ");
            this.getChildren().get(index).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        writer.write(" end");
    }
}

