/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class ConcatExpression
extends ExpressionBase {
    private static final long serialVersionUID = 0L;

    public ConcatExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public ConcatExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public ConcatExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.CONCAT;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        for (Expression child : this.getChildren()) {
            writer.write(delimiter);
            child.toEPL(writer, this.getPrecedence());
            delimiter = "||";
        }
    }
}

