/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.ForClauseKeyword;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ForClauseItem
implements Serializable {
    private static final long serialVersionUID = -8476488858601535928L;
    private ForClauseKeyword keyword;
    private List<Expression> expressions = new ArrayList<Expression>();

    public static ForClauseItem create(ForClauseKeyword keyword) {
        return new ForClauseItem(keyword);
    }

    public ForClauseItem() {
    }

    public ForClauseItem(ForClauseKeyword keyword) {
        this();
        this.setKeyword(keyword);
    }

    public ForClauseKeyword getKeyword() {
        return this.keyword;
    }

    public void setKeyword(ForClauseKeyword keyword) {
        this.keyword = keyword;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public void toEPL(StringWriter writer) {
        if (this.keyword == null) {
            return;
        }
        writer.write("for ");
        writer.write(this.keyword.getName());
        if (this.expressions.size() == 0) {
            return;
        }
        writer.write("(");
        String delimiter = "";
        for (Expression child : this.expressions) {
            writer.write(delimiter);
            child.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.write(")");
    }
}

