/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.StreamSelector;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InsertIntoClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private StreamSelector streamSelector;
    private String streamName;
    private List<String> columnNames;

    public InsertIntoClause() {
    }

    public static InsertIntoClause create(String streamName) {
        return new InsertIntoClause(streamName);
    }

    public static InsertIntoClause create(String streamName, String ... columns) {
        return new InsertIntoClause(streamName, columns);
    }

    public static InsertIntoClause create(String streamName, String[] columns, StreamSelector streamSelector) {
        if (streamSelector == StreamSelector.RSTREAM_ISTREAM_BOTH) {
            throw new IllegalArgumentException("Insert into only allows istream or rstream selection, not both");
        }
        return new InsertIntoClause(streamName, Arrays.asList(columns), streamSelector);
    }

    public InsertIntoClause(String streamName) {
        this.streamSelector = StreamSelector.ISTREAM_ONLY;
        this.streamName = streamName;
        this.columnNames = new ArrayList<String>();
    }

    public InsertIntoClause(String streamName, String[] columnNames) {
        this.streamSelector = StreamSelector.ISTREAM_ONLY;
        this.streamName = streamName;
        this.columnNames = Arrays.asList(columnNames);
    }

    public InsertIntoClause(String streamName, List<String> columnNames, StreamSelector streamSelector) {
        this.streamSelector = streamSelector;
        this.streamName = streamName;
        this.columnNames = columnNames;
    }

    public StreamSelector getStreamSelector() {
        return this.streamSelector;
    }

    public void setStreamSelector(StreamSelector streamSelector) {
        this.streamSelector = streamSelector;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void add(String columnName) {
        this.columnNames.add(columnName);
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter, boolean isTopLevel) {
        formatter.beginInsertInto(writer, isTopLevel);
        writer.write("insert ");
        if (this.streamSelector != StreamSelector.ISTREAM_ONLY) {
            writer.write(this.streamSelector.getEpl());
            writer.write(" ");
        }
        writer.write("into ");
        writer.write(this.streamName);
        if (this.columnNames.size() > 0) {
            writer.write("(");
            String delimiter = "";
            for (String name : this.columnNames) {
                writer.write(delimiter);
                writer.write(name);
                delimiter = ", ";
            }
            writer.write(")");
        }
    }
}

