/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import java.io.StringWriter;

public class MaxRowExpression
extends ExpressionBase {
    private static final long serialVersionUID = -286616738319179765L;

    public MaxRowExpression() {
    }

    public MaxRowExpression(String propertyOne, String propertyTwo, String[] moreProperties) {
        this.addChild(new PropertyValueExpression(propertyOne));
        this.addChild(new PropertyValueExpression(propertyTwo));
        for (int i = 0; i < moreProperties.length; ++i) {
            this.addChild(new PropertyValueExpression(moreProperties[i]));
        }
    }

    public MaxRowExpression(Expression exprOne, Expression exprTwo, Expression ... moreExpressions) {
        this.addChild(exprOne);
        this.addChild(exprTwo);
        for (int i = 0; i < moreExpressions.length; ++i) {
            this.addChild(moreExpressions[i]);
        }
    }

    public MaxRowExpression add(Object object) {
        this.getChildren().add(new ConstantExpression(object));
        return this;
    }

    public MaxRowExpression add(Expression expression) {
        this.getChildren().add(expression);
        return this;
    }

    public MaxRowExpression add(String propertyName) {
        this.getChildren().add(new PropertyValueExpression(propertyName));
        return this;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("max(");
        String delimiter = "";
        for (Expression expr : this.getChildren()) {
            writer.write(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(41);
    }
}

