/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Assignment;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.OnClause;
import com.espertech.esper.common.client.soda.UpdateClause;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OnUpdateClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private String windowName;
    private String optionalAsName;
    private List<Assignment> assignments;

    public OnUpdateClause() {
        this.assignments = new ArrayList<Assignment>();
    }

    public static OnUpdateClause create(String windowName, String optionalAsName) {
        return new OnUpdateClause(windowName, optionalAsName);
    }

    public OnUpdateClause(String windowName, String optionalAsName) {
        this.windowName = windowName;
        this.optionalAsName = optionalAsName;
        this.assignments = new ArrayList<Assignment>();
    }

    public void toEPL(StringWriter writer) {
        writer.write(this.windowName);
        if (this.optionalAsName != null) {
            writer.write(" as ");
            writer.write(this.optionalAsName);
        }
        writer.write(" ");
        UpdateClause.renderEPLAssignments(writer, this.assignments);
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public String getOptionalAsName() {
        return this.optionalAsName;
    }

    public void setOptionalAsName(String optionalAsName) {
        this.optionalAsName = optionalAsName;
    }

    public OnUpdateClause addAssignment(Expression expression) {
        this.assignments.add(new Assignment(expression));
        return this;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }
}

