/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.PatternExpr;
import com.espertech.esper.common.client.soda.PatternExprPrecedenceEnum;
import com.espertech.esper.common.client.soda.ProjectedStream;
import com.espertech.esper.common.client.soda.View;
import java.io.StringWriter;
import java.util.ArrayList;

public class PatternStream
extends ProjectedStream {
    private PatternExpr expression;
    private AnnotationPart[] annotations;
    private static final long serialVersionUID = -8321367637970657123L;

    public PatternStream() {
    }

    public static PatternStream create(PatternExpr expression) {
        return new PatternStream(expression);
    }

    public static PatternStream create(PatternExpr expression, String optStreamName) {
        return new PatternStream(expression, optStreamName);
    }

    public PatternStream(PatternExpr expression) {
        this(expression, null);
    }

    public PatternStream(PatternExpr expression, String optStreamName) {
        super(new ArrayList<View>(), optStreamName);
        this.expression = expression;
    }

    public PatternStream(PatternExpr expression, String optStreamName, AnnotationPart[] annotations) {
        super(new ArrayList<View>(), optStreamName);
        this.expression = expression;
        this.annotations = annotations;
    }

    public PatternExpr getExpression() {
        return this.expression;
    }

    public void setExpression(PatternExpr expression) {
        this.expression = expression;
    }

    public AnnotationPart[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationPart[] annotations) {
        this.annotations = annotations;
    }

    @Override
    public void toEPLProjectedStream(StringWriter writer, EPStatementFormatter formatter) {
        writer.write("pattern");
        if (this.annotations != null) {
            for (AnnotationPart part : this.annotations) {
                writer.write(32);
                part.toEPL(writer);
            }
        }
        writer.write(" [");
        if (this.expression != null) {
            this.expression.toEPL(writer, PatternExprPrecedenceEnum.MINIMUM, formatter);
        }
        writer.write(93);
    }

    @Override
    public void toEPLProjectedStreamType(StringWriter writer) {
        writer.write("pattern");
    }
}

