/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ConstantExpression;
import com.espertech.esper.common.client.soda.DotExpressionItem;
import com.espertech.esper.common.client.soda.DotExpressionItemCall;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class SingleRowMethodExpression
extends ExpressionBase {
    private static final long serialVersionUID = -8698785052124988195L;
    private List<DotExpressionItem> chain = new ArrayList<DotExpressionItem>();

    public SingleRowMethodExpression(String method, Object[] parameters) {
        ArrayList<Expression> parameterList = new ArrayList<Expression>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof Expression) {
                parameterList.add((Expression)parameters[i]);
                continue;
            }
            parameterList.add(new ConstantExpression(parameters[i]));
        }
        this.chain.add(new DotExpressionItemCall(method, parameterList));
    }

    public List<DotExpressionItem> getChain() {
        return this.chain;
    }

    public SingleRowMethodExpression(List<DotExpressionItem> chain) {
        this.chain = chain;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        DotExpressionItem.render(this.chain, writer, false);
    }
}

