/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class TimePeriodExpression
extends ExpressionBase {
    private boolean hasYears;
    private boolean hasMonths;
    private boolean hasWeeks;
    private boolean hasDays;
    private boolean hasHours;
    private boolean hasMinutes;
    private boolean hasSeconds;
    private boolean hasMilliseconds;
    private boolean hasMicroseconds;
    private static final long serialVersionUID = 1386645838943804276L;

    public TimePeriodExpression() {
    }

    public TimePeriodExpression(boolean hasYears, boolean hasMonths, boolean hasWeeks, boolean hasDays, boolean hasHours, boolean hasMinutes, boolean hasSeconds, boolean hasMilliseconds, boolean hasMicroseconds) {
        this.hasYears = hasYears;
        this.hasMonths = hasMonths;
        this.hasWeeks = hasWeeks;
        this.hasDays = hasDays;
        this.hasHours = hasHours;
        this.hasMinutes = hasMinutes;
        this.hasSeconds = hasSeconds;
        this.hasMilliseconds = hasMilliseconds;
        this.hasMicroseconds = hasMicroseconds;
    }

    public TimePeriodExpression(Expression yearsExpr, Expression monthsExpr, Expression weeksExpr, Expression daysExpr, Expression hoursExpr, Expression minutesExpr, Expression secondsExpr, Expression millisecondsExpr, Expression microsecondsExpr) {
        this.addExpr(yearsExpr, monthsExpr, weeksExpr, daysExpr, hoursExpr, minutesExpr, secondsExpr, millisecondsExpr, microsecondsExpr);
    }

    public TimePeriodExpression(boolean hasYears, boolean hasMonths, boolean hasWeeks, boolean hasDays, boolean hasHours, boolean hasMinutes, boolean hasSeconds, boolean hasMilliseconds) {
        this(hasYears, hasMonths, hasWeeks, hasDays, hasHours, hasMinutes, hasSeconds, hasMilliseconds, false);
    }

    public TimePeriodExpression(boolean hasDays, boolean hasHours, boolean hasMinutes, boolean hasSeconds, boolean hasMilliseconds) {
        this(false, false, false, hasDays, hasHours, hasMinutes, hasSeconds, hasMilliseconds, false);
    }

    public TimePeriodExpression(Expression yearsExpr, Expression monthsExpr, Expression weeksExpr, Expression daysExpr, Expression hoursExpr, Expression minutesExpr, Expression secondsExpr, Expression millisecondsExpr) {
        this(yearsExpr, monthsExpr, weeksExpr, daysExpr, hoursExpr, minutesExpr, secondsExpr, millisecondsExpr, null);
    }

    public TimePeriodExpression(Expression daysExpr, Expression hoursExpr, Expression minutesExpr, Expression secondsExpr, Expression millisecondsExpr) {
        this(null, null, null, daysExpr, hoursExpr, minutesExpr, secondsExpr, millisecondsExpr, null);
    }

    private void addExpr(Expression yearsExpr, Expression monthExpr, Expression weeksExpr, Expression daysExpr, Expression hoursExpr, Expression minutesExpr, Expression secondsExpr, Expression millisecondsExpr, Expression microsecondsExpr) {
        if (yearsExpr != null) {
            this.hasYears = true;
            this.addChild(yearsExpr);
        }
        if (monthExpr != null) {
            this.hasMonths = true;
            this.addChild(monthExpr);
        }
        if (weeksExpr != null) {
            this.hasWeeks = true;
            this.addChild(weeksExpr);
        }
        if (daysExpr != null) {
            this.hasDays = true;
            this.addChild(daysExpr);
        }
        if (hoursExpr != null) {
            this.hasHours = true;
            this.addChild(hoursExpr);
        }
        if (minutesExpr != null) {
            this.hasMinutes = true;
            this.addChild(minutesExpr);
        }
        if (secondsExpr != null) {
            this.hasSeconds = true;
            this.addChild(secondsExpr);
        }
        if (millisecondsExpr != null) {
            this.hasMilliseconds = true;
            this.addChild(millisecondsExpr);
        }
        if (microsecondsExpr != null) {
            this.hasMicroseconds = true;
            this.addChild(microsecondsExpr);
        }
    }

    public boolean isHasDays() {
        return this.hasDays;
    }

    public void setHasDays(boolean hasDays) {
        this.hasDays = hasDays;
    }

    public boolean isHasHours() {
        return this.hasHours;
    }

    public void setHasHours(boolean hasHours) {
        this.hasHours = hasHours;
    }

    public boolean isHasMinutes() {
        return this.hasMinutes;
    }

    public void setHasMinutes(boolean hasMinutes) {
        this.hasMinutes = hasMinutes;
    }

    public boolean isHasSeconds() {
        return this.hasSeconds;
    }

    public void setHasSeconds(boolean hasSeconds) {
        this.hasSeconds = hasSeconds;
    }

    public boolean isHasMilliseconds() {
        return this.hasMilliseconds;
    }

    public void setHasMilliseconds(boolean hasMilliseconds) {
        this.hasMilliseconds = hasMilliseconds;
    }

    public boolean isHasYears() {
        return this.hasYears;
    }

    public void setHasYears(boolean hasYears) {
        this.hasYears = hasYears;
    }

    public boolean isHasMonths() {
        return this.hasMonths;
    }

    public void setHasMonths(boolean hasMonths) {
        this.hasMonths = hasMonths;
    }

    public boolean isHasWeeks() {
        return this.hasWeeks;
    }

    public void setHasWeeks(boolean hasWeeks) {
        this.hasWeeks = hasWeeks;
    }

    public boolean isHasMicroseconds() {
        return this.hasMicroseconds;
    }

    public void setHasMicroseconds(boolean hasMicroseconds) {
        this.hasMicroseconds = hasMicroseconds;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        int countExpr = 0;
        if (this.hasYears) {
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" years");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMonths) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" months");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasWeeks) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" weeks");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasDays) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" days");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasHours) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" hours");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMinutes) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" minutes");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasSeconds) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" seconds");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMilliseconds) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" milliseconds");
            delimiter = " ";
            ++countExpr;
        }
        if (this.hasMicroseconds) {
            writer.write(delimiter);
            this.getChildren().get(countExpr).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.append(" microseconds");
        }
    }
}

