/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenMethod
implements CodegenMethodScope {
    private final Class returnType;
    private final String returnTypeName;
    private final CodegenBlock block;
    private final String additionalDebugInfo;
    private final CodegenSymbolProvider optionalSymbolProvider;
    private boolean isStatic;
    private List<CodegenMethod> children = Collections.emptyList();
    private List<CodegenExpressionRef> environment = Collections.emptyList();
    private List<CodegenNamedParam> localParams = Collections.emptyList();
    private List<Class> thrown = Collections.emptyList();
    private Set<String> deepParameters;
    private CodegenMethodWGraph assignedMethod;
    private String assignedProviderClassName;

    protected CodegenMethod(Class returnType, String returnTypeName, Class generator, CodegenSymbolProvider optionalSymbolProvider, CodegenScope env) {
        if (generator == null) {
            throw new IllegalArgumentException("Invalid null generator");
        }
        this.returnType = returnType;
        this.returnTypeName = returnTypeName;
        this.optionalSymbolProvider = optionalSymbolProvider;
        this.block = new CodegenBlock(this);
        this.additionalDebugInfo = env.isDebug() ? this.getGeneratorDetail(generator) : generator.getSimpleName();
    }

    public static CodegenMethod makeParentNode(Class returnType, Class generator, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        return new CodegenMethod(returnType, null, generator, CodegenSymbolProviderEmpty.INSTANCE, env);
    }

    public static CodegenMethod makeParentNode(Class returnType, Class generator, CodegenSymbolProvider symbolProvider, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        if (symbolProvider == null) {
            throw new IllegalArgumentException("No symbol provider");
        }
        return new CodegenMethod(returnType, null, generator, symbolProvider, env);
    }

    public static CodegenMethod makeParentNode(String returnTypeName, Class generator, CodegenSymbolProvider symbolProvider, CodegenScope env) {
        if (returnTypeName == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        if (symbolProvider == null) {
            throw new IllegalArgumentException("No symbol provider");
        }
        return new CodegenMethod(null, returnTypeName, generator, symbolProvider, env);
    }

    @Override
    public CodegenMethod makeChild(Class returnType, Class generator, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        return this.addChild(new CodegenMethod(returnType, null, generator, null, env));
    }

    @Override
    public CodegenMethod makeChild(String returnType, Class generator, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        return this.addChild(new CodegenMethod(null, returnType, generator, null, env));
    }

    @Override
    public CodegenMethod makeChildWithScope(Class returnType, Class generator, CodegenSymbolProvider symbolProvider, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        return this.addChild(new CodegenMethod(returnType, null, generator, symbolProvider, env));
    }

    public CodegenMethod makeChildWithScope(String returnType, Class generator, CodegenSymbolProvider symbolProvider, CodegenScope env) {
        if (returnType == null) {
            throw new IllegalArgumentException("Invalid null return type");
        }
        return this.addChild(new CodegenMethod(null, returnType, generator, symbolProvider, env));
    }

    @Override
    public CodegenMethod addSymbol(CodegenExpressionRef symbol) {
        if (this.environment.isEmpty()) {
            this.environment = new ArrayList<CodegenExpressionRef>(4);
        }
        this.environment.add(symbol);
        return this;
    }

    public void mergeClasses(Set<Class> classes) {
        this.block.mergeClasses(classes);
        classes.add(this.returnType);
        for (Class ex : this.thrown) {
            classes.add(ex);
        }
        for (CodegenNamedParam param : this.localParams) {
            param.mergeClasses(classes);
        }
    }

    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        this.block.traverseExpressions(consumer);
    }

    public CodegenSymbolProvider getOptionalSymbolProvider() {
        return this.optionalSymbolProvider;
    }

    public List<CodegenMethod> getChildren() {
        return this.children;
    }

    public List<CodegenExpressionRef> getEnvironment() {
        return this.environment;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public String getAdditionalDebugInfo() {
        return this.additionalDebugInfo;
    }

    public CodegenBlock getBlock() {
        return this.block;
    }

    public List<CodegenNamedParam> getLocalParams() {
        return this.localParams;
    }

    public CodegenMethod addParam(Class type, String name) {
        if (this.localParams.isEmpty()) {
            this.localParams = new ArrayList<CodegenNamedParam>(4);
        }
        this.localParams.add(new CodegenNamedParam(type, name));
        return this;
    }

    public CodegenMethod addParam(String typeName, String name) {
        if (this.localParams.isEmpty()) {
            this.localParams = new ArrayList<CodegenNamedParam>(4);
        }
        this.localParams.add(new CodegenNamedParam(typeName, name));
        return this;
    }

    public CodegenMethod addParam(List<CodegenNamedParam> params) {
        if (this.localParams.isEmpty()) {
            this.localParams = new ArrayList<CodegenNamedParam>(params.size());
        }
        this.localParams.addAll(params);
        return this;
    }

    public CodegenMethod addThrown(Class throwableClass) {
        if (this.thrown.isEmpty()) {
            this.thrown = new ArrayList<Class>();
        }
        this.thrown.add(throwableClass);
        return this;
    }

    public List<Class> getThrown() {
        return this.thrown;
    }

    public Set<String> getDeepParameters() {
        return this.deepParameters;
    }

    public void setDeepParameters(Set<String> deepParameters) {
        this.deepParameters = deepParameters;
    }

    public CodegenMethodWGraph getAssignedMethod() {
        return this.assignedMethod;
    }

    public void setAssignedMethod(CodegenMethodWGraph assignedMethod) {
        this.assignedMethod = assignedMethod;
    }

    public void setAssignedProviderClassName(String assignedProviderClassName) {
        this.assignedProviderClassName = assignedProviderClassName;
    }

    public CodegenMethod setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getAssignedProviderClassName() {
        return this.assignedProviderClassName;
    }

    public String toString() {
        return this.assignedMethod == null ? "CodegenMethod" : "CodegenMethod{name=" + this.assignedMethod.getName() + "}";
    }

    private String getGeneratorDetail(Class generator) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String stackString = null;
        for (int i = 1; i < 10; ++i) {
            if (stack[i].getClassName().contains(CodegenMethod.class.getPackage().getName())) continue;
            stackString = this.getStackString(i, stack);
            break;
        }
        if (stackString == null) {
            stackString = this.getStackString(3, stack);
        }
        if (stackString.contains("makeSelectExprProcessors")) {
            throw new UnsupportedOperationException();
        }
        return generator.getSimpleName() + " --- " + stackString;
    }

    private String getStackString(int i, StackTraceElement[] stack) {
        String fullClassName = stack[i].getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = stack[i].getMethodName();
        int lineNumber = stack[i].getLineNumber();
        return className + "." + methodName + "():" + lineNumber;
    }

    private CodegenMethod addChild(CodegenMethod methodNode) {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<CodegenMethod>();
        }
        this.children.add(methodNode);
        return methodNode;
    }
}

