/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenClassInterfacesAndExtension {
    private final List<CodegenClassReference> implemented = new ArrayList<CodegenClassReference>(2);
    private CodegenClassReference extended;

    public List<CodegenClassReference> getImplemented() {
        return this.implemented;
    }

    public CodegenClassReference getExtended() {
        return this.extended;
    }

    public void addInterfaceImplemented(Class clazzImplemented) {
        this.implemented.add(new CodegenClassReference(clazzImplemented));
    }

    public void addInterfaceImplemented(String classNameImplemented) {
        this.implemented.add(new CodegenClassReference(classNameImplemented));
    }

    public void setClassExtended(String classNameExtended) {
        this.extended = new CodegenClassReference(classNameExtended);
    }

    public void setClassExtended(Class clazzExtended) {
        this.extended = new CodegenClassReference(clazzExtended);
    }

    void addReferenced(Set<Class> classes) {
        for (CodegenClassReference implement : this.implemented) {
            implement.addReferenced(classes);
        }
        if (this.extended != null) {
            this.extended.addReferenced(classes);
        }
    }

    public void render(StringBuilder builder, Map<Class, String> imports) {
        if (!this.implemented.isEmpty()) {
            builder.append(" implements ");
            boolean first = true;
            for (CodegenClassReference implement : this.implemented) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                implement.render(builder, imports);
            }
        }
        if (this.extended != null) {
            builder.append(" extends ");
            this.extended.render(builder, imports);
        }
    }
}

