/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodegenInstanceAux {
    private final CodegenCtor serviceCtor;
    private final CodegenNamedMethods methods = new CodegenNamedMethods();
    private List<CodegenTypedParam> members;

    public CodegenInstanceAux(CodegenCtor serviceCtor) {
        this.serviceCtor = serviceCtor;
    }

    public CodegenCtor getServiceCtor() {
        return this.serviceCtor;
    }

    public void addMember(String name, Class type) {
        if (this.members == null) {
            this.members = new ArrayList<CodegenTypedParam>(2);
        }
        for (CodegenTypedParam member : this.members) {
            if (!member.getName().equals(name)) continue;
            throw new IllegalStateException("Member by name '" + name + "' already added");
        }
        this.members.add(new CodegenTypedParam(type, name));
    }

    public boolean hasMember(String name) {
        if (this.members == null) {
            return false;
        }
        for (CodegenTypedParam member : this.members) {
            if (!member.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<CodegenTypedParam> getMembers() {
        return this.members == null ? Collections.emptyList() : this.members;
    }

    public CodegenNamedMethods getMethods() {
        return this.methods;
    }
}

