/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionCastExpression
implements CodegenExpression {
    private final Class clazz;
    private final String typeName;
    private final CodegenExpression expression;

    public CodegenExpressionCastExpression(Class clazz, CodegenExpression expression) {
        if (clazz == null) {
            throw new IllegalArgumentException("Cast-to class is a null value");
        }
        this.clazz = clazz;
        this.typeName = null;
        this.expression = expression;
    }

    public CodegenExpressionCastExpression(String typeName, CodegenExpression expression) {
        if (typeName == null) {
            throw new IllegalArgumentException("Cast-to class is a null value");
        }
        this.clazz = null;
        this.typeName = typeName;
        this.expression = expression;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("((");
        if (this.clazz != null) {
            CodeGenerationHelper.appendClassName(builder, this.clazz, null, imports);
        } else {
            builder.append(this.typeName);
        }
        builder.append(")");
        this.expression.render(builder, imports, isInnerClass);
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        if (this.clazz != null) {
            classes.add(this.clazz);
        }
        this.expression.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.expression);
    }
}

