/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionConditional
implements CodegenExpression {
    private final CodegenExpression condition;
    private final CodegenExpression expressionTrue;
    private final CodegenExpression expressionFalse;

    public CodegenExpressionConditional(CodegenExpression condition, CodegenExpression expressionTrue, CodegenExpression expressionFalse) {
        this.condition = condition;
        this.expressionTrue = expressionTrue;
        this.expressionFalse = expressionFalse;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("(");
        this.condition.render(builder, imports, isInnerClass);
        builder.append(" ? ");
        this.expressionTrue.render(builder, imports, isInnerClass);
        builder.append(" : ");
        this.expressionFalse.render(builder, imports, isInnerClass);
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.condition.mergeClasses(classes);
        this.expressionTrue.mergeClasses(classes);
        this.expressionFalse.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.condition);
        consumer.accept(this.expressionTrue);
        consumer.accept(this.expressionFalse);
    }
}

