/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenChainElement;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionExprDotMethodChain
implements CodegenExpression {
    private final CodegenExpression expression;
    private final List<CodegenChainElement> chain = new ArrayList<CodegenChainElement>(2);

    public CodegenExpressionExprDotMethodChain(CodegenExpression expression) {
        this.expression = expression;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.expression.render(builder, imports, isInnerClass);
        for (CodegenChainElement element : this.chain) {
            builder.append(".");
            element.render(builder, imports, isInnerClass);
        }
    }

    public CodegenExpressionExprDotMethodChain add(String method, CodegenExpression ... params) {
        this.chain.add(new CodegenChainElement(method, params));
        return this;
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.expression.mergeClasses(classes);
        for (CodegenChainElement element : this.chain) {
            element.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.expression);
        for (CodegenChainElement element : this.chain) {
            element.traverseExpressions(consumer);
        }
    }
}

