/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionLocalMethod
implements CodegenExpression {
    private final CodegenMethod methodNode;
    private final List<CodegenExpression> parameters;

    public CodegenExpressionLocalMethod(CodegenMethod methodNode, List<CodegenExpression> parameters) {
        this.methodNode = methodNode;
        if (methodNode == null) {
            throw new IllegalArgumentException("Null method node");
        }
        this.parameters = parameters;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.methodNode.getAssignedMethod() == null) {
            throw new IllegalStateException("Method has no assignment for " + this.methodNode.getAdditionalDebugInfo());
        }
        if (this.methodNode.getAssignedProviderClassName() != null) {
            builder.append(this.methodNode.getAssignedProviderClassName()).append(".");
        }
        builder.append(this.methodNode.getAssignedMethod().getName()).append("(");
        String delimiter = "";
        for (CodegenExpression expression : this.parameters) {
            builder.append(delimiter);
            expression.render(builder, imports, isInnerClass);
            delimiter = ",";
        }
        if (this.methodNode.getOptionalSymbolProvider() == null) {
            for (String name : this.methodNode.getDeepParameters()) {
                builder.append(delimiter);
                builder.append(name);
                delimiter = ",";
            }
        }
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.methodNode.mergeClasses(classes);
        for (CodegenExpression param : this.parameters) {
            param.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        CodegenExpressionBuilder.traverseMultiple(this.parameters, consumer);
    }

    public CodegenMethod getMethodNode() {
        return this.methodNode;
    }
}

