/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.collection.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionNewAnonymousClass
extends CodegenStatementWBlockBase
implements CodegenExpression {
    private final Class interfaceOrSuperClass;
    private final List<CodegenExpression> ctorParams;
    private final List<Pair<String, CodegenMethod>> methods = new ArrayList<Pair<String, CodegenMethod>>(2);

    public CodegenExpressionNewAnonymousClass(CodegenBlock parentBlock, Class interfaceOrSuperClass, List<CodegenExpression> ctorParams) {
        super(parentBlock);
        this.interfaceOrSuperClass = interfaceOrSuperClass;
        this.ctorParams = ctorParams;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("new ");
        CodeGenerationHelper.appendClassName(builder, this.interfaceOrSuperClass, null, imports);
        builder.append("(");
        CodegenExpressionBuilder.renderExpressions(builder, this.ctorParams.toArray(new CodegenExpression[this.ctorParams.size()]), imports, isInnerClass);
        builder.append(") {\n");
        CodegenClassMethods methods = new CodegenClassMethods();
        for (Pair<String, CodegenMethod> pair : this.methods) {
            CodegenStackGenerator.recursiveBuildStack(pair.getSecond(), pair.getFirst(), methods);
        }
        String delimiter = "";
        for (CodegenMethodWGraph publicMethod : methods.getPublicMethods()) {
            builder.append(delimiter);
            publicMethod.render(builder, imports, true, isInnerClass, indent, level + 1);
            delimiter = "\n";
        }
        for (CodegenMethodWGraph method : methods.getPrivateMethods()) {
            builder.append(delimiter);
            method.render(builder, imports, false, isInnerClass, indent, level + 1);
            delimiter = "\n";
        }
        indent.indent(builder, level);
        builder.append("}");
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.render(builder, imports, isInnerClass, 4, new CodegenIndent(true));
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        classes.add(this.interfaceOrSuperClass);
        for (CodegenExpression codegenExpression : this.ctorParams) {
            codegenExpression.mergeClasses(classes);
        }
        for (Pair pair : this.methods) {
            ((CodegenMethod)pair.getSecond()).mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        for (CodegenExpression codegenExpression : this.ctorParams) {
            consumer.accept(codegenExpression);
        }
        for (Pair pair : this.methods) {
            ((CodegenMethod)pair.getSecond()).traverseExpressions(consumer);
        }
    }

    public void addMethod(String name, CodegenMethod methodNode) {
        this.methods.add(new Pair<String, CodegenMethod>(name, methodNode));
    }
}

