/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionStaticMethod
implements CodegenExpression {
    private final Class target;
    private final String targetClassName;
    private final String methodName;
    private final CodegenExpression[] params;

    public CodegenExpressionStaticMethod(Class target, String methodName, CodegenExpression[] params) {
        this.target = target;
        this.targetClassName = null;
        this.methodName = methodName;
        this.params = params;
    }

    public CodegenExpressionStaticMethod(String targetClassName, String methodName, CodegenExpression[] params) {
        this.target = null;
        this.targetClassName = targetClassName;
        this.methodName = methodName;
        this.params = params;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.target != null) {
            CodeGenerationHelper.appendClassName(builder, this.target, null, imports);
        } else {
            builder.append(this.targetClassName);
        }
        builder.append(".");
        builder.append(this.methodName);
        builder.append("(");
        CodegenExpressionBuilder.renderExpressions(builder, this.params, imports, isInnerClass);
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        classes.add(this.target);
        CodegenExpressionBuilder.mergeClassesExpressions(classes, this.params);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        CodegenExpressionBuilder.traverseMultiple(this.params, consumer);
    }
}

