/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementAssignNamed
extends CodegenStatementBase {
    private final CodegenExpression lhs;
    private final CodegenExpression assignment;

    public CodegenStatementAssignNamed(CodegenExpression lhs, CodegenExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException("Assignment not provided");
        }
        this.lhs = lhs;
        this.assignment = assignment;
    }

    @Override
    public void renderStatement(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.lhs.render(builder, imports, isInnerClass);
        builder.append("=");
        this.assignment.render(builder, imports, isInnerClass);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.assignment.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.lhs);
        consumer.accept(this.assignment);
    }
}

