/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementIfConditionBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementIf
extends CodegenStatementWBlockBase {
    private List<CodegenStatementIfConditionBlock> blocks = new ArrayList<CodegenStatementIfConditionBlock>();
    private CodegenBlock optionalElse;

    public CodegenStatementIf(CodegenBlock parent) {
        super(parent);
    }

    public CodegenBlock ifBlock(CodegenExpression condition) {
        if (!this.blocks.isEmpty()) {
            throw new IllegalStateException("Use add-else instead");
        }
        CodegenBlock block = new CodegenBlock(this);
        this.blocks.add(new CodegenStatementIfConditionBlock(condition, block));
        return block;
    }

    public CodegenBlock addElseIf(CodegenExpression condition) {
        if (this.blocks.isEmpty()) {
            throw new IllegalStateException("Use if-block instead");
        }
        CodegenBlock block = new CodegenBlock(this);
        this.blocks.add(new CodegenStatementIfConditionBlock(condition, block));
        return block;
    }

    public CodegenBlock addElse() {
        if (this.blocks.isEmpty()) {
            throw new IllegalStateException("Use if-block instead");
        }
        if (this.optionalElse != null) {
            throw new IllegalStateException("Else already found");
        }
        this.optionalElse = new CodegenBlock(this);
        return this.optionalElse;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        Iterator<CodegenStatementIfConditionBlock> it = this.blocks.iterator();
        CodegenStatementIfConditionBlock first = it.next();
        first.render(builder, imports, isInnerClass, level, indent);
        while (it.hasNext()) {
            builder.append(" else ");
            it.next().render(builder, imports, isInnerClass, level, indent);
        }
        if (this.optionalElse != null) {
            builder.append(" else {\n");
            this.optionalElse.render(builder, imports, isInnerClass, level + 1, indent);
            indent.indent(builder, level);
            builder.append("}");
        }
        builder.append("\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        for (CodegenStatementIfConditionBlock pair : this.blocks) {
            pair.mergeClasses(classes);
        }
        if (this.optionalElse != null) {
            this.optionalElse.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        for (CodegenStatementIfConditionBlock pair : this.blocks) {
            pair.traverseExpressions(consumer);
        }
        if (this.optionalElse != null) {
            this.optionalElse.traverseExpressions(consumer);
        }
    }
}

