/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyFour;
import com.espertech.esper.common.internal.collection.IntSeqKeySix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeyFive
implements IntSeqKey {
    private final int one;
    private final int two;
    private final int three;
    private final int four;
    private final int five;

    public IntSeqKeyFive(int one, int two, int three, int four, int five) {
        this.one = one;
        this.two = two;
        this.three = three;
        this.four = four;
        this.five = five;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 6) {
            return false;
        }
        IntSeqKeySix o = (IntSeqKeySix)other;
        return this.one == o.getOne() && this.two == o.getTwo() && this.three == o.getThree() && this.four == o.getFour() && this.five == o.getFive();
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeySix(this.one, this.two, this.three, this.four, this.five, num);
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return new IntSeqKeyFour(this.one, this.two, this.three, this.four);
    }

    @Override
    public int length() {
        return 5;
    }

    @Override
    public int last() {
        return this.five;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one, this.two, this.three, this.four, this.five};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyFive that = (IntSeqKeyFive)o;
        if (this.one != that.one) {
            return false;
        }
        if (this.two != that.two) {
            return false;
        }
        if (this.three != that.three) {
            return false;
        }
        if (this.four != that.four) {
            return false;
        }
        return this.five == that.five;
    }

    public int hashCode() {
        int result = this.one;
        result = 31 * result + this.two;
        result = 31 * result + this.three;
        result = 31 * result + this.four;
        result = 31 * result + this.five;
        return result;
    }

    public int getOne() {
        return this.one;
    }

    public int getTwo() {
        return this.two;
    }

    public int getThree() {
        return this.three;
    }

    public int getFour() {
        return this.four;
    }

    public int getFive() {
        return this.five;
    }

    public static void write(IntSeqKeyFive key, DataOutput output) throws IOException {
        output.writeInt(key.one);
        output.writeInt(key.two);
        output.writeInt(key.three);
        output.writeInt(key.four);
        output.writeInt(key.five);
    }

    public static IntSeqKeyFive read(DataInput input) throws IOException {
        return new IntSeqKeyFive(input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt());
    }
}

