/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.util.Copyable;
import java.util.HashSet;
import java.util.Set;

public class PathDeploymentEntry<E> {
    private final String deploymentId;
    private final E entity;
    private Set<String> dependencyDeploymentIds;

    public PathDeploymentEntry(String deploymentId, E entity) {
        this.deploymentId = deploymentId;
        this.entity = entity;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public E getEntity() {
        return this.entity;
    }

    public void addDependency(String deploymentIdDep) {
        if (this.dependencyDeploymentIds == null) {
            this.dependencyDeploymentIds = new HashSet<String>(4);
        }
        this.dependencyDeploymentIds.add(deploymentIdDep);
    }

    public Set<String> getDependencies() {
        return this.dependencyDeploymentIds;
    }

    public void removeDependency(String deploymentId) {
        if (this.dependencyDeploymentIds == null) {
            return;
        }
        this.dependencyDeploymentIds.remove(deploymentId);
        if (this.dependencyDeploymentIds.isEmpty()) {
            this.dependencyDeploymentIds = null;
        }
    }

    public PathDeploymentEntry<E> copy() {
        Object reference = this.entity instanceof Copyable ? ((Copyable)this.entity).copy() : this.entity;
        return new PathDeploymentEntry<E>(this.deploymentId, reference);
    }
}

