/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.collection.MultiKeyArrayBoolean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayByte;
import com.espertech.esper.common.internal.collection.MultiKeyArrayChar;
import com.espertech.esper.common.internal.collection.MultiKeyArrayDouble;
import com.espertech.esper.common.internal.collection.MultiKeyArrayFloat;
import com.espertech.esper.common.internal.collection.MultiKeyArrayInt;
import com.espertech.esper.common.internal.collection.MultiKeyArrayLong;
import com.espertech.esper.common.internal.collection.MultiKeyArrayObject;
import com.espertech.esper.common.internal.collection.MultiKeyArrayShort;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefEmpty;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefPredetermined;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefUUIDBased;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefWSerde;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.StmtClassForgeableMultiKey;
import com.espertech.esper.common.internal.compile.multikey.StmtClassForgeableMultiKeySerde;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayBooleanSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayByteSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayCharSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayDoubleSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayFloatSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayIntSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayLongSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayObjectSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArrayShortSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MultiKeyPlanner {
    public static boolean requiresDeepEquals(Class arrayComponentType) {
        return arrayComponentType == Object.class || arrayComponentType.isArray();
    }

    public static MultiKeyPlan planMultiKeyDistinct(boolean isDistinct, EventType eventType, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        if (!isDistinct) {
            return new MultiKeyPlan(Collections.emptyList(), MultiKeyClassRefEmpty.INSTANCE);
        }
        String[] propertyNames = eventType.getPropertyNames();
        Class[] props = new Class[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            props[i] = eventType.getPropertyType(propertyNames[i]);
        }
        return MultiKeyPlanner.planMultiKey(props, false, raw, serdeResolver);
    }

    public static MultiKeyPlan planMultiKey(ExprNode[] criteriaExpressions, boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        return MultiKeyPlanner.planMultiKey(ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions), lenientEquals, raw, serdeResolver);
    }

    public static MultiKeyPlan planMultiKey(ExprForge[] criteriaExpressions, boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        return MultiKeyPlanner.planMultiKey(ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions), lenientEquals, raw, serdeResolver);
    }

    public static Class getMKClassForComponentType(Class componentType) {
        if (componentType == Boolean.TYPE) {
            return MultiKeyArrayBoolean.class;
        }
        if (componentType == Byte.TYPE) {
            return MultiKeyArrayByte.class;
        }
        if (componentType == Character.TYPE) {
            return MultiKeyArrayChar.class;
        }
        if (componentType == Short.TYPE) {
            return MultiKeyArrayShort.class;
        }
        if (componentType == Integer.TYPE) {
            return MultiKeyArrayInt.class;
        }
        if (componentType == Long.TYPE) {
            return MultiKeyArrayLong.class;
        }
        if (componentType == Float.TYPE) {
            return MultiKeyArrayFloat.class;
        }
        if (componentType == Double.TYPE) {
            return MultiKeyArrayDouble.class;
        }
        return MultiKeyArrayObject.class;
    }

    public static DataInputOutputSerde getMKSerdeClassForComponentType(Class componentType) {
        if (componentType == Boolean.TYPE) {
            return DIOMultiKeyArrayBooleanSerde.INSTANCE;
        }
        if (componentType == Byte.TYPE) {
            return DIOMultiKeyArrayByteSerde.INSTANCE;
        }
        if (componentType == Character.TYPE) {
            return DIOMultiKeyArrayCharSerde.INSTANCE;
        }
        if (componentType == Short.TYPE) {
            return DIOMultiKeyArrayShortSerde.INSTANCE;
        }
        if (componentType == Integer.TYPE) {
            return DIOMultiKeyArrayIntSerde.INSTANCE;
        }
        if (componentType == Long.TYPE) {
            return DIOMultiKeyArrayLongSerde.INSTANCE;
        }
        if (componentType == Float.TYPE) {
            return DIOMultiKeyArrayFloatSerde.INSTANCE;
        }
        if (componentType == Double.TYPE) {
            return DIOMultiKeyArrayDoubleSerde.INSTANCE;
        }
        return DIOMultiKeyArrayObjectSerde.INSTANCE;
    }

    public static MultiKeyPlan planMultiKey(final Class[] types, final boolean lenientEquals, StatementRawInfo raw, SerdeCompileTimeResolver serdeResolver) {
        if (types == null || types.length == 0) {
            return new MultiKeyPlan(Collections.emptyList(), MultiKeyClassRefEmpty.INSTANCE);
        }
        if (types.length == 1) {
            Class paramType = types[0];
            if (paramType == null || !paramType.isArray()) {
                DataInputOutputSerdeForge serdeForge = serdeResolver.serdeForKeyNonArray(paramType, raw);
                return new MultiKeyPlan(Collections.emptyList(), new MultiKeyClassRefWSerde(serdeForge, types));
            }
            Class mkClass = MultiKeyPlanner.getMKClassForComponentType(paramType.getComponentType());
            DataInputOutputSerde mkSerde = MultiKeyPlanner.getMKSerdeClassForComponentType(paramType.getComponentType());
            return new MultiKeyPlan(Collections.emptyList(), new MultiKeyClassRefPredetermined(mkClass, types, new DataInputOutputSerdeForgeSingleton(mkSerde.getClass())));
        }
        Class[] boxed = new Class[types.length];
        for (int i = 0; i < boxed.length; ++i) {
            boxed[i] = JavaClassHelper.getBoxedType(types[i]);
        }
        final MultiKeyClassRefUUIDBased classNames = new MultiKeyClassRefUUIDBased(boxed);
        StmtClassForgeableFactory factoryMK = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableMultiKey(classNames.getClassNameMK(classPostfix), packageScope, types, lenientEquals);
            }
        };
        final DataInputOutputSerdeForge[] forges = serdeResolver.serdeForMultiKey(types, raw);
        StmtClassForgeableFactory factoryMKSerde = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableMultiKeySerde(classNames.getClassNameMKSerde(classPostfix), packageScope, types, classNames.getClassNameMK(classPostfix), forges);
            }
        };
        List<StmtClassForgeableFactory> forgeables = Arrays.asList(factoryMK, factoryMKSerde);
        return new MultiKeyPlan(forgeables, classNames);
    }

    public static Object toMultiKey(Object keyValue) {
        Class<?> componentType = keyValue.getClass().getComponentType();
        if (componentType == Boolean.TYPE) {
            return new MultiKeyArrayBoolean((boolean[])keyValue);
        }
        if (componentType == Byte.TYPE) {
            return new MultiKeyArrayByte((byte[])keyValue);
        }
        if (componentType == Character.TYPE) {
            return new MultiKeyArrayChar((char[])keyValue);
        }
        if (componentType == Short.TYPE) {
            return new MultiKeyArrayShort((short[])keyValue);
        }
        if (componentType == Integer.TYPE) {
            return new MultiKeyArrayInt((int[])keyValue);
        }
        if (componentType == Long.TYPE) {
            return new MultiKeyArrayLong((long[])keyValue);
        }
        if (componentType == Float.TYPE) {
            return new MultiKeyArrayFloat((float[])keyValue);
        }
        if (componentType == Double.TYPE) {
            return new MultiKeyArrayDouble((double[])keyValue);
        }
        return new MultiKeyArrayObject((Object[])keyValue);
    }
}

