/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.util.MultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class StmtClassForgeableMultiKey
implements StmtClassForgeable {
    private final String className;
    private final CodegenPackageScope packageScope;
    private final Class[] types;
    private final boolean lenientEquals;

    public StmtClassForgeableMultiKey(String className, CodegenPackageScope packageScope, Class[] types, boolean lenientEquals) {
        this.className = className;
        this.packageScope = packageScope;
        this.types = types;
        this.lenientEquals = lenientEquals;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        ArrayList<CodegenTypedParam> params = new ArrayList<CodegenTypedParam>();
        for (int i = 0; i < this.types.length; ++i) {
            params.add(new CodegenTypedParam(JavaClassHelper.getBoxedType(this.types[i]), "k" + i));
        }
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableMultiKey.class, includeDebugSymbols, params);
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod hashMethod = CodegenMethod.makeParentNode(Integer.TYPE, StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        this.makeHashMethod(this.types.length, hashMethod);
        CodegenStackGenerator.recursiveBuildStack(hashMethod, "hashCode", methods);
        CodegenMethod equalsMethod = CodegenMethod.makeParentNode(Boolean.TYPE, StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Object.class, "o");
        this.makeEqualsMethod(this.types.length, equalsMethod);
        CodegenStackGenerator.recursiveBuildStack(equalsMethod, "equals", methods);
        CodegenMethod getNumKeysMethod = CodegenMethod.makeParentNode(Integer.TYPE, StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getNumKeysMethod.getBlock().methodReturn(CodegenExpressionBuilder.constant(this.types.length));
        CodegenStackGenerator.recursiveBuildStack(getNumKeysMethod, "getNumKeys", methods);
        CodegenMethod getKeyMethod = CodegenMethod.makeParentNode(Object.class, StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(Integer.TYPE, "num");
        this.makeGetKeyMethod(this.types.length, getKeyMethod);
        CodegenStackGenerator.recursiveBuildStack(getKeyMethod, "getKey", methods);
        CodegenMethod toStringMethod = CodegenMethod.makeParentNode(String.class, StmtClassForgeableMultiKey.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        this.makeToStringMethod(toStringMethod);
        CodegenStackGenerator.recursiveBuildStack(toStringMethod, "toString", methods);
        return new CodegenClass(CodegenClassType.KEYPROVISIONING, MultiKey.class, this.className, classScope, Collections.emptyList(), ctor, methods, Collections.emptyList());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.MULTIKEY;
    }

    private void makeEqualsMethod(int length, CodegenMethod equalsMethod) {
        equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("this"), CodegenExpressionBuilder.ref("o"))).blockReturn(CodegenExpressionBuilder.constant(true));
        if (!this.lenientEquals) {
            equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("o")), CodegenExpressionBuilder.not(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("this"), "getClass", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("o"), "getClass", new CodegenExpression[0]))), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(false)).declareVar(this.className, "k", CodegenExpressionBuilder.cast(this.className, (CodegenExpression)CodegenExpressionBuilder.ref("o")));
            for (int i = 0; i < length; ++i) {
                CodegenExpressionRef self = CodegenExpressionBuilder.ref("k" + i);
                CodegenExpressionRef other = CodegenExpressionBuilder.ref("k.k" + i);
                if (i < length - 1) {
                    CodegenExpression notEquals = StmtClassForgeableMultiKey.getNotEqualsExpression(this.types[i], self, other);
                    equalsMethod.getBlock().ifCondition(notEquals).blockReturn(CodegenExpressionBuilder.constantFalse());
                    continue;
                }
                CodegenExpression equals = StmtClassForgeableMultiKey.getEqualsExpression(this.types[i], self, other);
                equalsMethod.getBlock().methodReturn(equals);
            }
            return;
        }
        equalsMethod.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref("o"), MultiKey.class))).blockReturn(CodegenExpressionBuilder.constant(false)).declareVar(MultiKey.class, "k", CodegenExpressionBuilder.cast(MultiKey.class, (CodegenExpression)CodegenExpressionBuilder.ref("o")));
        for (int i = 0; i < length; ++i) {
            CodegenExpressionRef self = CodegenExpressionBuilder.ref("k" + i);
            CodegenExpression other = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("k"), "getKey", CodegenExpressionBuilder.constant(i));
            if (this.types[i].isArray()) {
                other = CodegenExpressionBuilder.cast(this.types[i], other);
            }
            if (i < length - 1) {
                CodegenExpression notEquals = StmtClassForgeableMultiKey.getNotEqualsExpression(this.types[i], self, other);
                equalsMethod.getBlock().ifCondition(notEquals).blockReturn(CodegenExpressionBuilder.constantFalse());
                continue;
            }
            CodegenExpression equals = StmtClassForgeableMultiKey.getEqualsExpression(this.types[i], self, other);
            equalsMethod.getBlock().methodReturn(equals);
        }
    }

    private void makeGetKeyMethod(int length, CodegenMethod method) {
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("num"), length, true);
        for (int i = 0; i < length; ++i) {
            blocks[i].blockReturn(CodegenExpressionBuilder.ref("k" + i));
        }
    }

    private static CodegenExpression getEqualsExpression(Class type, CodegenExpressionRef self, CodegenExpression other) {
        if (!type.isArray()) {
            CodegenExpression cond = CodegenExpressionBuilder.notEqualsNull(self);
            CodegenExpression condTrue = CodegenExpressionBuilder.exprDotMethod(self, "equals", other);
            CodegenExpression condFalse = CodegenExpressionBuilder.equalsNull(other);
            return CodegenExpressionBuilder.conditional(cond, condTrue, condFalse);
        }
        if (MultiKeyPlanner.requiresDeepEquals(type.getComponentType())) {
            return CodegenExpressionBuilder.staticMethod(Arrays.class, "deepEquals", self, other);
        }
        return CodegenExpressionBuilder.staticMethod(Arrays.class, "equals", self, other);
    }

    private static CodegenExpression getNotEqualsExpression(Class type, CodegenExpressionRef self, CodegenExpression other) {
        if (!type.isArray()) {
            CodegenExpression cond = CodegenExpressionBuilder.notEqualsNull(self);
            CodegenExpression condTrue = CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(self, "equals", other));
            CodegenExpression condFalse = CodegenExpressionBuilder.notEqualsNull(other);
            return CodegenExpressionBuilder.conditional(cond, condTrue, condFalse);
        }
        if (MultiKeyPlanner.requiresDeepEquals(type.getComponentType())) {
            return CodegenExpressionBuilder.not(CodegenExpressionBuilder.staticMethod(Arrays.class, "deepEquals", self, other));
        }
        return CodegenExpressionBuilder.not(CodegenExpressionBuilder.staticMethod(Arrays.class, "equals", self, other));
    }

    private void makeHashMethod(int length, CodegenMethod hashMethod) {
        CodegenExpression computeHash = StmtClassForgeableMultiKey.getHashExpression(CodegenExpressionBuilder.ref("k0"), this.types[0]);
        hashMethod.getBlock().declareVar(Integer.TYPE, "h", computeHash);
        for (int i = 1; i < length; ++i) {
            computeHash = StmtClassForgeableMultiKey.getHashExpression(CodegenExpressionBuilder.ref("k" + i), this.types[i]);
            hashMethod.getBlock().assignRef("h", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(31), "*", CodegenExpressionBuilder.ref("h")), "+", computeHash));
        }
        hashMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("h"));
    }

    private static CodegenExpression getHashExpression(CodegenExpressionRef key, Class type) {
        if (!type.isArray()) {
            return CodegenExpressionBuilder.conditional(CodegenExpressionBuilder.notEqualsNull(key), CodegenExpressionBuilder.exprDotMethod(key, "hashCode", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0));
        }
        if (MultiKeyPlanner.requiresDeepEquals(type.getComponentType())) {
            return CodegenExpressionBuilder.staticMethod(Arrays.class, "deepHashCode", key);
        }
        return CodegenExpressionBuilder.staticMethod(Arrays.class, "hashCode", key);
    }

    private void makeToStringMethod(CodegenMethod toStringMethod) {
        toStringMethod.getBlock().declareVar(StringBuilder.class, "b", CodegenExpressionBuilder.newInstance(StringBuilder.class, new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant(MultiKey.class.getSimpleName() + "["));
        for (int i = 0; i < this.types.length; ++i) {
            CodegenExpressionRef self;
            if (i > 0) {
                toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant(","));
            }
            CodegenExpression text = self = CodegenExpressionBuilder.ref("k" + i);
            if (this.types[i].isArray()) {
                text = CodegenExpressionBuilder.staticMethod(Arrays.class, "toString", self);
            }
            toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", text);
        }
        toStringMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("b"), "append", CodegenExpressionBuilder.constant("]")).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b"), "toString", new CodegenExpression[0]));
    }
}

