/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.compile.stage2.EvalNodeAnalysisResult;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNodeUtilFactoryFilter;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootNode;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.everydistinct.EvalEveryDistinctForgeNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterForgeNode;
import com.espertech.esper.common.internal.epl.pattern.guard.EvalGuardForgeNode;
import com.espertech.esper.common.internal.epl.pattern.matchuntil.EvalMatchUntilForgeNode;
import com.espertech.esper.common.internal.epl.pattern.observer.EvalObserverForgeNode;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalNodeUtil {
    private static final Logger log = LoggerFactory.getLogger(EvalNodeUtil.class);
    public static final EvalFactoryNode[] EMPTY_FACTORY_ARRAY = new EvalFactoryNode[0];

    public static EvalNodeAnalysisResult recursiveAnalyzeChildNodes(EvalForgeNode currentNode) {
        EvalNodeAnalysisResult evalNodeAnalysisResult = new EvalNodeAnalysisResult();
        EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, currentNode);
        return evalNodeAnalysisResult;
    }

    private static void recursiveAnalyzeChildNodes(EvalNodeAnalysisResult evalNodeAnalysisResult, EvalForgeNode currentNode) {
        if (currentNode instanceof EvalFilterForgeNode || currentNode instanceof EvalGuardForgeNode || currentNode instanceof EvalObserverForgeNode || currentNode instanceof EvalMatchUntilForgeNode || currentNode instanceof EvalEveryDistinctForgeNode) {
            evalNodeAnalysisResult.addNode(currentNode);
        }
        if (currentNode instanceof EvalObserverForgeNode) {
            evalNodeAnalysisResult.addNode(currentNode);
        }
        for (EvalForgeNode node : currentNode.getChildNodes()) {
            EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, node);
        }
    }

    public static Set<EvalForgeNode> recursiveGetChildNodes(EvalForgeNode currentNode, EvalNodeUtilFactoryFilter filter) {
        LinkedHashSet<EvalForgeNode> result = new LinkedHashSet<EvalForgeNode>();
        if (filter.consider(currentNode)) {
            result.add(currentNode);
        }
        EvalNodeUtil.recursiveGetChildNodes(result, currentNode, filter);
        return result;
    }

    private static void recursiveGetChildNodes(Set<EvalForgeNode> set, EvalForgeNode currentNode, EvalNodeUtilFactoryFilter filter) {
        for (EvalForgeNode node : currentNode.getChildNodes()) {
            if (filter.consider(node)) {
                set.add(node);
            }
            EvalNodeUtil.recursiveGetChildNodes(set, node, filter);
        }
    }

    public static EvalNode makeEvalNodeSingleChild(EvalFactoryNode child, PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        return child.makeEvalNode(agentInstanceContext, parentNode);
    }

    public static EvalRootNode makeRootNodeFromFactory(EvalRootFactoryNode rootFactoryNode, PatternAgentInstanceContext patternAgentInstanceContext) {
        return (EvalRootNode)rootFactoryNode.makeEvalNode(patternAgentInstanceContext, null);
    }

    public static EvalNode[] makeEvalNodeChildren(EvalFactoryNode[] factories, PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode[] children = new EvalNode[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            children[i] = factories[i].makeEvalNode(agentInstanceContext, parentNode);
        }
        return children;
    }
}

