/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParamComparator;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlan;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.contained.PropertyEvaluatorForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public final class FilterSpecCompiled {
    private static final FilterSpecParamComparator COMPARATOR_PARAMETERS = new FilterSpecParamComparator();
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecPlanForge parameters;
    private final PropertyEvaluatorForge optionalPropertyEvaluator;
    private int filterCallbackId = -1;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, FilterSpecPlanForge filterParameters, PropertyEvaluatorForge optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = FilterSpecCompiled.sortRemoveDups(filterParameters);
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public void setFilterCallbackId(int filterCallbackId) {
        this.filterCallbackId = filterCallbackId;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecPlanForge getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluatorForge getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + this.parameters.toString());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        return this.parameters.equalsFilter(other.parameters);
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        for (FilterSpecPlanPathForge path : this.parameters.getPaths()) {
            for (FilterSpecPlanPathTripletForge triplet : path.getTriplets()) {
                hashCode ^= 31 * triplet.hashCode();
            }
        }
        return hashCode;
    }

    protected static FilterSpecPlanForge sortRemoveDups(FilterSpecPlanForge parameters) {
        FilterSpecPlanPathForge[] processed = new FilterSpecPlanPathForge[parameters.getPaths().length];
        for (int i = 0; i < parameters.getPaths().length; ++i) {
            processed[i] = FilterSpecCompiled.sortRemoveDups(parameters.getPaths()[i]);
        }
        return new FilterSpecPlanForge(processed, parameters.getFilterConfirm(), parameters.getFilterNegate(), parameters.getConvertorForge());
    }

    protected static FilterSpecPlanPathForge sortRemoveDups(FilterSpecPlanPathForge parameters) {
        if (parameters.getTriplets().length <= 1) {
            return parameters;
        }
        ArrayDeque result = new ArrayDeque();
        TreeMap map = new TreeMap(COMPARATOR_PARAMETERS);
        for (FilterSpecPlanPathTripletForge parameter : parameters.getTriplets()) {
            ArrayList<FilterSpecPlanPathTripletForge> list = (ArrayList<FilterSpecPlanPathTripletForge>)map.get((Object)parameter.getParam().getFilterOperator());
            if (list == null) {
                list = new ArrayList<FilterSpecPlanPathTripletForge>();
                map.put(parameter.getParam().getFilterOperator(), list);
            }
            boolean hasDuplicate = false;
            for (FilterSpecPlanPathTripletForge existing : list) {
                if (!existing.getParam().getLookupable().equals(parameter.getParam().getLookupable())) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            list.add(parameter);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        FilterSpecPlanPathTripletForge[] triplets = result.toArray(new FilterSpecPlanPathTripletForge[0]);
        return new FilterSpecPlanPathForge(triplets, parameters.getPathNegate());
    }

    public CodegenMethod makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(FilterSpecActivatable.class, FilterSpecCompiled.class, (CodegenScope)classScope);
        if (this.filterCallbackId == -1) {
            throw new IllegalStateException("Unassigned filter callback id");
        }
        CodegenExpression propertyEval = this.optionalPropertyEvaluator == null ? CodegenExpressionBuilder.constantNull() : this.optionalPropertyEvaluator.make(method, symbols, classScope);
        method.getBlock().declareVar(EventType.class, "eventType", EventTypeUtility.resolveTypeCodegen(this.filterForEventType, EPStatementInitServices.REF)).declareVar(FilterSpecPlan.class, "plan", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.parameters.codegenWithEventType(method, classScope), CodegenExpressionBuilder.ref("eventType"), symbols.getAddInitSvc(method))).declareVar(FilterSpecActivatable.class, "activatable", CodegenExpressionBuilder.newInstance(FilterSpecActivatable.class, SAIFFInitializeSymbolWEventType.REF_EVENTTYPE, CodegenExpressionBuilder.constant(this.filterForEventType.getName()), CodegenExpressionBuilder.ref("plan"), propertyEval, CodegenExpressionBuilder.constant(this.filterCallbackId))).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterSpecActivatableRegistry", new CodegenExpression[0]).add("register", CodegenExpressionBuilder.ref("activatable"))).methodReturn(CodegenExpressionBuilder.ref("activatable"));
        return method;
    }

    public static List<FilterSpecParamExprNodeForge> makeExprNodeList(List<FilterSpecCompiled> filterSpecCompileds, List<FilterSpecParamExprNodeForge> additionalBooleanExpressions) {
        LinkedHashSet<FilterSpecParamExprNodeForge> boolExprs = new LinkedHashSet<FilterSpecParamExprNodeForge>();
        for (FilterSpecCompiled spec : filterSpecCompileds) {
            spec.traverseFilterBooleanExpr(boolExprs::add);
        }
        boolExprs.addAll(additionalBooleanExpressions);
        return new ArrayList<FilterSpecParamExprNodeForge>(boolExprs);
    }

    public void traverseFilterBooleanExpr(Consumer<FilterSpecParamExprNodeForge> consumer) {
        for (FilterSpecPlanPathForge path : this.parameters.getPaths()) {
            for (FilterSpecPlanPathTripletForge triplet : path.getTriplets()) {
                if (!(triplet.getParam() instanceof FilterSpecParamExprNodeForge)) continue;
                consumer.accept((FilterSpecParamExprNodeForge)triplet.getParam());
            }
        }
    }
}

