/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantAnyTypeForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FilterSpecCompilerConsolidateUtil {
    protected static void consolidate(FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        boolean haveConsolidated;
        HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecPlanPathTripletForge>> mapOfParams = new HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecPlanPathTripletForge>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecPlanPathTripletForge currenttriplet : filterParamExprMap.getTriplets()) {
                FilterOperator op;
                ExprFilterSpecLookupableForge lookupable = currenttriplet.getParam().getLookupable();
                Pair<ExprFilterSpecLookupableForge, FilterOperator> key = new Pair<ExprFilterSpecLookupableForge, FilterOperator>(lookupable, op = currenttriplet.getParam().getFilterOperator());
                ArrayList<FilterSpecPlanPathTripletForge> existingParam = (ArrayList<FilterSpecPlanPathTripletForge>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecPlanPathTripletForge>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currenttriplet);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompilerConsolidateUtil.consolidate(entry, filterParamExprMap, statementName);
            }
        } while (haveConsolidated);
    }

    private static void consolidate(List<FilterSpecPlanPathTripletForge> items, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        FilterOperator op = items.get(0).getParam().getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            FilterSpecCompilerConsolidateUtil.handleConsolidateNotEqual(items, filterParamExprMap, statementName);
        } else {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    private static void handleConsolidateNotEqual(List<FilterSpecPlanPathTripletForge> parameters, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        FilterSpecPlanPathTripletForge triplet2;
        ArrayList<FilterSpecParamInValueForge> values = new ArrayList<FilterSpecParamInValueForge>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecPlanPathTripletForge triplet2 : parameters) {
            FilterSpecParamForge eventProp;
            FilterSpecParamForge param = triplet2.getParam();
            if (param instanceof FilterSpecParamConstantForge) {
                FilterSpecParamConstantForge constantParam = (FilterSpecParamConstantForge)param;
                Object constant = constantParam.getFilterConstant();
                values.add(new FilterForEvalConstantAnyTypeForge(constant));
            } else if (param instanceof FilterSpecParamEventPropForge) {
                eventProp = (FilterSpecParamEventPropForge)param;
                values.add(new FilterForEvalEventPropForge(((FilterSpecParamEventPropForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropForge)eventProp).getExprIdentNodeEvaluator(), ((FilterSpecParamEventPropForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropForge)eventProp).getCoercionType())));
            } else if (param instanceof FilterSpecParamEventPropIndexedForge) {
                eventProp = (FilterSpecParamEventPropIndexedForge)param;
                values.add(new FilterForEvalEventPropIndexedForge(((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventIndex(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropIndexedForge)eventProp).getEventType(), ((FilterSpecParamEventPropIndexedForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropIndexedForge)eventProp).getCoercionType())));
            } else {
                throw new IllegalArgumentException("Unknown filter parameter:" + param.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(triplet2);
        }
        FilterSpecParamInForge param = new FilterSpecParamInForge(parameters.get(0).getParam().getLookupable(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        triplet2 = new FilterSpecPlanPathTripletForge(param, null);
        filterParamExprMap.put(lastNotEqualsExprNode, triplet2);
    }
}

