/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExecution;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerWidthBasic;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerWidthWithConditions;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import java.util.ArrayList;
import java.util.List;

public class FilterSpecCompilerIndexPlanner {
    public static final String PROPERTY_NAME_BOOLEAN_EXPRESSION = ".boolean_expression";

    public static FilterSpecPlanForge planFilterParameters(List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterSpecPlanForge plan = FilterSpecCompilerIndexPlanner.planFilterParametersInternal(validatedNodes, args);
        FilterSpecCompilerIndexPlanner.promoteControlConfirmSinglePathSingleTriplet(plan);
        return plan;
    }

    private static FilterSpecPlanForge planFilterParametersInternal(List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (validatedNodes.isEmpty()) {
            return FilterSpecPlanForge.EMPTY;
        }
        if (args.compileTimeServices.getConfiguration().getCompiler().getExecution().getFilterIndexPlanning() == ConfigurationCompilerExecution.FilterIndexPlanning.NONE) {
            FilterSpecCompilerIndexPlannerHelper.decomposeCheckAggregation(validatedNodes);
            return FilterSpecCompilerIndexPlanner.buildNoPlan(validatedNodes, args);
        }
        boolean performConditionPlanning = FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.CONDITIONS, args.statementRawInfo, args.compileTimeServices);
        FilterSpecParaForgeMap filterParamExprMap = new FilterSpecParaForgeMap();
        ExprNode topLevelNegation = FilterSpecCompilerIndexPlannerHelper.decomposePopulateConsolidate(filterParamExprMap, performConditionPlanning, validatedNodes, args);
        int countUnassigned = filterParamExprMap.countUnassignedExpressions();
        if (countUnassigned == 0) {
            return FilterSpecPlanForge.makePlanFromTriplets(filterParamExprMap.getTriplets(), topLevelNegation, args);
        }
        int filterServiceMaxFilterWidth = args.compileTimeServices.getConfiguration().getCompiler().getExecution().getFilterServiceMaxFilterWidth();
        Hint hint = HintEnum.MAX_FILTER_WIDTH.getHint(args.statementRawInfo.getAnnotations());
        if (hint != null) {
            String hintValue = HintEnum.MAX_FILTER_WIDTH.getHintAssignedValue(hint);
            filterServiceMaxFilterWidth = Integer.parseInt(hintValue);
        }
        FilterSpecPlanForge plan = null;
        if (filterServiceMaxFilterWidth > 0) {
            plan = performConditionPlanning ? FilterSpecCompilerIndexPlannerWidthWithConditions.planRemainingNodesWithConditions(filterParamExprMap, args, filterServiceMaxFilterWidth, topLevelNegation) : FilterSpecCompilerIndexPlannerWidthBasic.planRemainingNodesBasic(filterParamExprMap, args, filterServiceMaxFilterWidth);
        }
        if (plan != null) {
            return plan;
        }
        ArrayList<FilterSpecPlanPathTripletForge> triplets = new ArrayList<FilterSpecPlanPathTripletForge>(filterParamExprMap.getTriplets());
        List<ExprNode> unassignedExpressions = filterParamExprMap.getUnassignedExpressions();
        FilterSpecPlanPathTripletForge triplet = FilterSpecCompilerIndexPlannerHelper.makeRemainingNode(unassignedExpressions, args);
        triplets.add(triplet);
        return FilterSpecPlanForge.makePlanFromTriplets(triplets, topLevelNegation, args);
    }

    private static FilterSpecPlanForge buildNoPlan(List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterSpecPlanPathTripletForge triplet = FilterSpecCompilerIndexPlannerHelper.makeRemainingNode(validatedNodes, args);
        FilterSpecPlanPathTripletForge[] triplets = new FilterSpecPlanPathTripletForge[]{triplet};
        FilterSpecPlanPathForge path = new FilterSpecPlanPathForge(triplets, null);
        FilterSpecPlanPathForge[] paths = new FilterSpecPlanPathForge[]{path};
        return new FilterSpecPlanForge(paths, null, null, null);
    }

    private static void promoteControlConfirmSinglePathSingleTriplet(FilterSpecPlanForge plan) {
        if (plan.getPaths().length != 1) {
            return;
        }
        FilterSpecPlanPathForge path = plan.getPaths()[0];
        if (path.getTriplets().length != 1) {
            return;
        }
        ExprNode controlConfirm = path.getTriplets()[0].getTripletConfirm();
        if (controlConfirm == null) {
            return;
        }
        plan.setFilterConfirm(controlConfirm);
        path.getTriplets()[0].setTripletConfirm(null);
    }
}

