/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorBooleanLimitedExprPrequalify;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorValueLimitedExpr;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeWithChainSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeWithParentPair;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.filter.ExprFilterReboolValueNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamValueLimitedExprForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamValueNullForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class FilterSpecCompilerIndexPlannerBooleanLimited {
    protected static FilterSpecParamForge handleBooleanLimited(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StreamTypeService streamTypeService, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        if (!FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.BOOLCOMPOSITE, raw, services)) {
            return null;
        }
        boolean prequalified = FilterSpecCompilerIndexPlannerBooleanLimited.prequalify(constituent);
        if (!prequalified) {
            return null;
        }
        RewriteDescriptor desc = FilterSpecCompilerIndexPlannerBooleanLimited.findRewrite(constituent);
        if (desc == null) {
            return null;
        }
        if (desc instanceof RewriteDescriptorNoValueExpr) {
            String reboolExpression = ExprNodeUtilityPrint.toExpressionStringMinPrecedence(constituent, new ExprNodeRenderableFlags(false));
            ExprFilterSpecLookupableForge lookupable = new ExprFilterSpecLookupableForge(reboolExpression, null, constituent.getForge(), null, true, null);
            return new FilterSpecParamValueNullForge(lookupable, FilterOperator.REBOOL);
        }
        RewriteDescriptorWithValueExpr withValueExpr = (RewriteDescriptorWithValueExpr)desc;
        ExprNode valueExpression = withValueExpr.valueExpression;
        Class valueExpressionType = valueExpression.getForge().getEvaluationType();
        ExprFilterReboolValueNode replacement = new ExprFilterReboolValueNode(valueExpressionType);
        ExprNodeUtilityModify.replaceChildNode(withValueExpr.valueExpressionParent, valueExpression, replacement);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, raw, services).withIsFilterExpression(true).build();
        ExprNode rebool = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.FILTER, constituent, validationContext);
        DataInputOutputSerdeForge serde = services.getSerdeResolver().serdeForFilter(valueExpressionType, raw);
        MatchedEventConvertorForge convertor = FilterSpecCompilerIndexPlannerHelper.getMatchEventConvertor(valueExpression, taggedEventTypes, arrayEventTypes, allTagNamesOrdered);
        String reboolExpression = ExprNodeUtilityPrint.toExpressionStringMinPrecedence(constituent, new ExprNodeRenderableFlags(false));
        ExprFilterSpecLookupableForge lookupable = new ExprFilterSpecLookupableForge(reboolExpression, null, rebool.getForge(), valueExpressionType, true, serde);
        return new FilterSpecParamValueLimitedExprForge(lookupable, FilterOperator.REBOOL, valueExpression, convertor, null);
    }

    private static boolean prequalify(ExprNode constituent) {
        FilterSpecExprNodeVisitorBooleanLimitedExprPrequalify prequalify = new FilterSpecExprNodeVisitorBooleanLimitedExprPrequalify();
        constituent.accept(prequalify);
        if (!prequalify.isLimited()) {
            return false;
        }
        ExprNodeIdentifierAndStreamRefVisitor streamRefVisitor = new ExprNodeIdentifierAndStreamRefVisitor(false);
        constituent.accept(streamRefVisitor);
        boolean hasStreamRefZero = false;
        for (ExprNodePropOrStreamDesc ref : streamRefVisitor.getRefs()) {
            if (ref.getStreamNum() != 0) continue;
            hasStreamRefZero = true;
            break;
        }
        return hasStreamRefZero && !streamRefVisitor.isHasWildcardOrStreamAlias();
    }

    private static RewriteDescriptor findRewrite(ExprNode parent) {
        List<ExprNodeWithParentPair> valueExpressions = FilterSpecCompilerIndexPlannerBooleanLimited.findValueExpressionsDeepMayNull(parent);
        if (valueExpressions == null) {
            return new RewriteDescriptorNoValueExpr();
        }
        if (valueExpressions.size() == 1) {
            ExprNodeWithParentPair pair = valueExpressions.get(0);
            return new RewriteDescriptorWithValueExpr(pair.getNode(), pair.getParent());
        }
        ArrayList<ExprNodeWithParentPair> nonConstants = new ArrayList<ExprNodeWithParentPair>(valueExpressions.size());
        for (ExprNodeWithParentPair expr : valueExpressions) {
            if (expr.getNode().getForge().getForgeConstantType().isConstant()) continue;
            nonConstants.add(expr);
        }
        if (nonConstants.size() == 1) {
            ExprNodeWithParentPair pair = (ExprNodeWithParentPair)nonConstants.get(0);
            return new RewriteDescriptorWithValueExpr(pair.getNode(), pair.getParent());
        }
        return null;
    }

    private static List<ExprNodeWithParentPair> findValueExpressionsDeepMayNull(ExprNode parent) {
        AtomicReference<List<ExprNodeWithParentPair>> pairs = new AtomicReference<List<ExprNodeWithParentPair>>();
        FilterSpecCompilerIndexPlannerBooleanLimited.findValueExpressionsDeepRecursive(parent, pairs);
        return pairs.get();
    }

    private static void findValueExpressionsDeepRecursive(ExprNode parent, AtomicReference<List<ExprNodeWithParentPair>> pairsRef) {
        for (ExprNode child : parent.getChildNodes()) {
            FilterSpecCompilerIndexPlannerBooleanLimited.findValueExpr(child, parent, pairsRef);
        }
        if (parent instanceof ExprNodeWithChainSpec) {
            ExprNodeWithChainSpec chainableNode = (ExprNodeWithChainSpec)((Object)parent);
            for (Chainable chainable : chainableNode.getChainSpec()) {
                for (ExprNode param : chainable.getParametersOrEmpty()) {
                    FilterSpecCompilerIndexPlannerBooleanLimited.findValueExpr(param, parent, pairsRef);
                }
            }
        }
    }

    private static void findValueExpr(ExprNode child, ExprNode parent, AtomicReference<List<ExprNodeWithParentPair>> pairsRef) {
        FilterSpecExprNodeVisitorValueLimitedExpr valueVisitor = new FilterSpecExprNodeVisitorValueLimitedExpr();
        child.accept(valueVisitor);
        if (!valueVisitor.isLimited()) {
            FilterSpecCompilerIndexPlannerBooleanLimited.findValueExpressionsDeepRecursive(child, pairsRef);
            return;
        }
        List<ExprNodeWithParentPair> pairs = pairsRef.get();
        if (pairs == null) {
            pairs = new ArrayList<ExprNodeWithParentPair>(2);
            pairsRef.set(pairs);
        }
        pairs.add(new ExprNodeWithParentPair(child, parent));
    }

    private static class RewriteDescriptorWithValueExpr
    extends RewriteDescriptor {
        private final ExprNode valueExpression;
        private final ExprNode valueExpressionParent;

        public RewriteDescriptorWithValueExpr(ExprNode valueExpression, ExprNode valueExpressionParent) {
            this.valueExpression = valueExpression;
            this.valueExpressionParent = valueExpressionParent;
        }

        public ExprNode getValueExpression() {
            return this.valueExpression;
        }

        public ExprNode getValueExpressionParent() {
            return this.valueExpressionParent;
        }
    }

    private static class RewriteDescriptorNoValueExpr
    extends RewriteDescriptor {
        private RewriteDescriptorNoValueExpr() {
        }
    }

    private static abstract class RewriteDescriptor {
        private RewriteDescriptor() {
        }
    }
}

