/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantAnyTypeForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalContextPropForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalDeployTimeConstForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalLimitedExprForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class FilterSpecCompilerIndexPlannerInSetOfValues {
    protected static FilterSpecParamForge handleInSetNode(ExprInNode constituent, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        ExprNode left = constituent.getChildNodes()[0];
        ExprFilterSpecLookupableForge lookupable = null;
        if (left instanceof ExprFilterOptimizableNode) {
            ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            lookupable = filterOptimizableNode.getFilterLookupable();
        } else if (FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.LKUPCOMPOSITE, raw, services) && FilterSpecCompilerIndexPlannerHelper.isLimitedLookupableExpression(left)) {
            lookupable = FilterSpecCompilerIndexPlannerHelper.makeLimitedLookupableForgeMayNull(left, raw, services);
        }
        if (lookupable == null) {
            return null;
        }
        FilterOperator op = FilterOperator.IN_LIST_OF_VALUES;
        if (constituent.isNotIn()) {
            op = FilterOperator.NOT_IN_LIST_OF_VALUES;
        }
        int expectedNumberOfConstants = constituent.getChildNodes().length - 1;
        ArrayList<FilterSpecParamInValueForge> listofValues = new ArrayList<FilterSpecParamInValueForge>();
        Iterator<ExprNode> it = Arrays.asList(constituent.getChildNodes()).iterator();
        it.next();
        while (it.hasNext()) {
            SimpleNumberCoercer coercer;
            ExprNode subNode = it.next();
            if (subNode.getForge().getForgeConstantType().isCompileTimeConstant()) {
                Object constant = subNode.getForge().getExprEvaluator().evaluate(null, true, null);
                if (constant instanceof Collection) {
                    return null;
                }
                if (constant instanceof Map) {
                    return null;
                }
                if (constant != null && constant.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(constant); ++i) {
                        Object arrayElement = Array.get(constant, i);
                        Object arrayElementCoerced = FilterSpecCompilerIndexPlannerHelper.handleConstantsCoercion(lookupable, arrayElement);
                        listofValues.add(new FilterForEvalConstantAnyTypeForge(arrayElementCoerced));
                        if (i <= 0) continue;
                        ++expectedNumberOfConstants;
                    }
                    continue;
                }
                constant = FilterSpecCompilerIndexPlannerHelper.handleConstantsCoercion(lookupable, constant);
                listofValues.add(new FilterForEvalConstantAnyTypeForge(constant));
                continue;
            }
            if (subNode instanceof ExprContextPropertyNode) {
                ExprContextPropertyNode contextPropertyNode = (ExprContextPropertyNode)((Object)subNode);
                Class returnType = contextPropertyNode.getType();
                if (JavaClassHelper.isCollectionMapOrArray(returnType)) {
                    FilterSpecCompilerIndexPlannerInSetOfValues.checkArrayCoercion(returnType, lookupable.getReturnType(), lookupable.getExpression());
                    coercer = null;
                } else {
                    coercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(left.getForge().getEvaluationType(), contextPropertyNode.getType(), lookupable.getExpression());
                }
                Class finalReturnType = coercer != null ? coercer.getReturnType() : returnType;
                listofValues.add(new FilterForEvalContextPropForge(contextPropertyNode.getPropertyName(), contextPropertyNode.getGetter(), coercer, finalReturnType));
                continue;
            }
            if (subNode.getForge().getForgeConstantType().isDeployTimeTimeConstant() && subNode instanceof ExprNodeDeployTimeConst) {
                ExprNodeDeployTimeConst deployTimeConst = (ExprNodeDeployTimeConst)((Object)subNode);
                Class returnType = subNode.getForge().getEvaluationType();
                if (JavaClassHelper.isCollectionMapOrArray(returnType)) {
                    FilterSpecCompilerIndexPlannerInSetOfValues.checkArrayCoercion(returnType, lookupable.getReturnType(), lookupable.getExpression());
                    coercer = null;
                } else {
                    coercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(left.getForge().getEvaluationType(), returnType, lookupable.getExpression());
                }
                listofValues.add(new FilterForEvalDeployTimeConstForge(deployTimeConst, coercer, returnType));
                continue;
            }
            if (subNode instanceof ExprIdentNode) {
                FilterSpecParamInValueForge inValue;
                ExprIdentNode identNodeInner = (ExprIdentNode)subNode;
                if (identNodeInner.getStreamId() == 0) break;
                boolean isMustCoerce = false;
                Class coerceToType = JavaClassHelper.getBoxedType(lookupable.getReturnType());
                Class identReturnType = identNodeInner.getForge().getEvaluationType();
                if (JavaClassHelper.isCollectionMapOrArray(identReturnType)) {
                    FilterSpecCompilerIndexPlannerInSetOfValues.checkArrayCoercion(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                    coerceToType = identReturnType;
                } else if (identReturnType != lookupable.getReturnType()) {
                    if (!JavaClassHelper.isNumeric(lookupable.getReturnType())) break;
                    if (!JavaClassHelper.canCoerce(identReturnType, lookupable.getReturnType())) {
                        FilterSpecCompilerIndexPlannerHelper.throwConversionError(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                    }
                    isMustCoerce = true;
                }
                String streamName = identNodeInner.getResolvedStreamName();
                if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
                    Pair<Integer, String> indexAndProp = FilterSpecCompilerIndexPlannerHelper.getStreamIndex(identNodeInner.getResolvedPropertyName());
                    EventType innerEventType = FilterSpecCompilerIndexPlannerHelper.getArrayInnerEventType(arrayEventTypes, streamName);
                    inValue = new FilterForEvalEventPropIndexedForge(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), innerEventType, isMustCoerce, coerceToType);
                } else {
                    inValue = new FilterForEvalEventPropForge(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName(), identNodeInner.getExprEvaluatorIdent(), isMustCoerce, coerceToType);
                }
                listofValues.add(inValue);
                continue;
            }
            if (!FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.VALUECOMPOSITE, raw, services) || !FilterSpecCompilerIndexPlannerHelper.isLimitedValueExpression(subNode)) continue;
            MatchedEventConvertorForge convertor = FilterSpecCompilerIndexPlannerHelper.getMatchEventConvertor(subNode, taggedEventTypes, arrayEventTypes, allTagNamesOrdered);
            Class valueType = subNode.getForge().getEvaluationType();
            Class lookupableType = lookupable.getReturnType();
            SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupableType, valueType, lookupable.getExpression());
            FilterForEvalLimitedExprForge forge = new FilterForEvalLimitedExprForge(subNode, convertor, numberCoercer);
            listofValues.add(forge);
        }
        if (listofValues.size() == expectedNumberOfConstants) {
            return new FilterSpecParamInForge(lookupable, op, listofValues);
        }
        return null;
    }

    private static void checkArrayCoercion(Class returnTypeValue, Class returnTypeLookupable, String propertyName) throws ExprValidationException {
        if (returnTypeValue == null || !returnTypeValue.isArray()) {
            return;
        }
        if (!JavaClassHelper.isArrayTypeCompatible(returnTypeLookupable, returnTypeValue.getComponentType())) {
            FilterSpecCompilerIndexPlannerHelper.throwConversionError(returnTypeValue.getComponentType(), returnTypeLookupable, propertyName);
        }
    }
}

